/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionName;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.functions.Signature;
import io.crate.types.TypeSignature;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.lucene.util.StringHelper;

public final class OidHash {
    private static int oid(String key) {
        byte[] b = key.getBytes(StandardCharsets.UTF_8);
        return StringHelper.murmurhash3_x86_32((byte[])b, (int)0, (int)b.length, (int)0);
    }

    public static int relationOid(RelationInfo relationInfo) {
        Type t = relationInfo.relationType() == RelationInfo.RelationType.VIEW ? Type.VIEW : Type.TABLE;
        return OidHash.oid(t.toString() + relationInfo.ident().fqn());
    }

    public static int schemaOid(String name) {
        return OidHash.oid(Type.SCHEMA.toString() + name);
    }

    public static int primaryKeyOid(RelationInfo relationInfo) {
        String primaryKey = Lists2.joinOn(" ", relationInfo.primaryKey(), ColumnIdent::name);
        return OidHash.oid(Type.PRIMARY_KEY.toString() + relationInfo.ident().fqn() + primaryKey);
    }

    public static int constraintOid(String relationName, String constraintName, String constraintType) {
        return OidHash.oid(Type.CONSTRAINT.toString() + relationName + constraintName + constraintType);
    }

    public static int functionOid(Signature sig) {
        FunctionName name = sig.getName();
        return OidHash.oid(Type.PROC.toString() + name.schema() + name.name() + OidHash.argTypesToStr(sig.getArgumentTypes()));
    }

    @VisibleForTesting
    static String argTypesToStr(List<TypeSignature> typeSignatures) {
        return Lists2.joinOn(" ", typeSignatures, ts -> {
            try {
                return ts.createType().getName();
            }
            catch (IllegalArgumentException i) {
                String baseName = ts.getBaseTypeName();
                List<TypeSignature> innerTs = ts.getParameters();
                return baseName + (String)(innerTs.isEmpty() ? "" : "_" + OidHash.argTypesToStr(innerTs));
            }
        });
    }

    static enum Type {
        SCHEMA,
        TABLE,
        VIEW,
        CONSTRAINT,
        PRIMARY_KEY,
        PROC;

    }
}

