/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.information;

import io.crate.analyze.user.Privilege;
import io.crate.execution.engine.collect.files.SqlFeatureContext;
import io.crate.execution.engine.collect.sources.InformationSchemaIterables;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.information.ColumnContext;
import io.crate.metadata.PartitionInfo;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.RoutineInfo;
import io.crate.metadata.information.InformationCharacterSetsTable;
import io.crate.metadata.information.InformationColumnsTableInfo;
import io.crate.metadata.information.InformationKeyColumnUsageTableInfo;
import io.crate.metadata.information.InformationPartitionsTableInfo;
import io.crate.metadata.information.InformationReferentialConstraintsTableInfo;
import io.crate.metadata.information.InformationRoutinesTableInfo;
import io.crate.metadata.information.InformationSchemataTableInfo;
import io.crate.metadata.information.InformationSqlFeaturesTableInfo;
import io.crate.metadata.information.InformationTableConstraintsTableInfo;
import io.crate.metadata.information.InformationTablesTableInfo;
import io.crate.metadata.information.InformationViewsTableInfo;
import io.crate.metadata.table.ConstraintInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.view.ViewInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class InformationSchemaTableDefinitions {
    private final Map<RelationName, StaticTableDefinition<?>> tableDefinitions = new HashMap(10);

    @Inject
    public InformationSchemaTableDefinitions(InformationSchemaIterables informationSchemaIterables) {
        this.tableDefinitions.put(InformationSchemataTableInfo.IDENT, new StaticTableDefinition<SchemaInfo>(informationSchemaIterables::schemas, (user, s) -> user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, s.name()), InformationSchemataTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationTablesTableInfo.IDENT, new StaticTableDefinition<RelationInfo>(informationSchemaIterables::relations, (user, t) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, t.ident().fqn()) || user.hasAnyPrivilege(Privilege.Clazz.VIEW, t.ident().fqn()), InformationTablesTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationViewsTableInfo.IDENT, new StaticTableDefinition<ViewInfo>(informationSchemaIterables::views, (user, t) -> user.hasAnyPrivilege(Privilege.Clazz.VIEW, t.ident().fqn()), InformationViewsTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationPartitionsTableInfo.IDENT, new StaticTableDefinition<PartitionInfo>(informationSchemaIterables::partitions, (user, p) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, p.name().relationName().fqn()), InformationPartitionsTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationColumnsTableInfo.IDENT, new StaticTableDefinition<ColumnContext>(informationSchemaIterables::columns, (user, c) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, c.tableInfo.ident().fqn()) || user.hasAnyPrivilege(Privilege.Clazz.VIEW, c.tableInfo.ident().fqn()), InformationColumnsTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationTableConstraintsTableInfo.IDENT, new StaticTableDefinition<ConstraintInfo>(informationSchemaIterables::constraints, (user, t) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, t.relationName().fqn()), InformationTableConstraintsTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationRoutinesTableInfo.IDENT, new StaticTableDefinition<RoutineInfo>(informationSchemaIterables::routines, (user, r) -> user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, r.schema()), InformationRoutinesTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationSqlFeaturesTableInfo.IDENT, new StaticTableDefinition<SqlFeatureContext>(() -> CompletableFuture.completedFuture(informationSchemaIterables.features()), InformationSqlFeaturesTableInfo.create().expressions(), false));
        this.tableDefinitions.put(InformationKeyColumnUsageTableInfo.IDENT, new StaticTableDefinition<InformationSchemaIterables.KeyColumnUsage>(informationSchemaIterables::keyColumnUsage, (user, k) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, k.getFQN()), InformationKeyColumnUsageTableInfo.create().expressions()));
        this.tableDefinitions.put(InformationReferentialConstraintsTableInfo.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(informationSchemaIterables.referentialConstraintsInfos()), InformationReferentialConstraintsTableInfo.create().expressions(), false));
        this.tableDefinitions.put(InformationCharacterSetsTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Arrays.asList(new Void[]{null})), InformationCharacterSetsTable.create().expressions(), false));
    }

    public StaticTableDefinition<?> get(RelationName relationName) {
        return this.tableDefinitions.get(relationName);
    }
}

