/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.information;

import io.crate.common.collections.MapBuilder;
import io.crate.metadata.information.InformationCharacterSetsTable;
import io.crate.metadata.information.InformationColumnsTableInfo;
import io.crate.metadata.information.InformationKeyColumnUsageTableInfo;
import io.crate.metadata.information.InformationPartitionsTableInfo;
import io.crate.metadata.information.InformationReferentialConstraintsTableInfo;
import io.crate.metadata.information.InformationRoutinesTableInfo;
import io.crate.metadata.information.InformationSchemataTableInfo;
import io.crate.metadata.information.InformationSqlFeaturesTableInfo;
import io.crate.metadata.information.InformationTableConstraintsTableInfo;
import io.crate.metadata.information.InformationTablesTableInfo;
import io.crate.metadata.information.InformationViewsTableInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class InformationSchemaInfo
implements SchemaInfo {
    public static final String NAME = "information_schema";
    private final Map<String, TableInfo> tableInfoMap = MapBuilder.treeMapBuilder().put("tables", InformationTablesTableInfo.create()).put("views", InformationViewsTableInfo.create()).put("columns", InformationColumnsTableInfo.create()).put("key_column_usage", InformationKeyColumnUsageTableInfo.create()).put("table_partitions", InformationPartitionsTableInfo.create()).put("table_constraints", InformationTableConstraintsTableInfo.create()).put("referential_constraints", InformationReferentialConstraintsTableInfo.create()).put("routines", InformationRoutinesTableInfo.create()).put("schemata", InformationSchemataTableInfo.create()).put("sql_features", InformationSqlFeaturesTableInfo.create()).put("character_sets", InformationCharacterSetsTable.create()).immutableMap();

    @Inject
    public InformationSchemaInfo() {
    }

    @Override
    public TableInfo getTableInfo(String name) {
        return this.tableInfoMap.get(name);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void invalidateTableCache(String tableName) {
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return this.tableInfoMap.values();
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void update(ClusterChangedEvent event) {
    }
}

