/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.information;

import io.crate.expression.reference.information.ColumnContext;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.StringType;
import java.util.Map;

public class InformationColumnsTableInfo {
    public static final String NAME = "columns";
    public static final RelationName IDENT = new RelationName("information_schema", "columns");
    private static final String IS_GENERATED_NEVER = "NEVER";
    private static final String IS_GENERATED_ALWAYS = "ALWAYS";
    private static final Integer NUMERIC_PRECISION_RADIX = 2;
    private static final Integer DATETIME_PRECISION = 3;
    private static final Map<Integer, Integer> PRECISION_BY_TYPE_ID = Map.ofEntries(Map.entry(2, 8), Map.entry(8, 16), Map.entry(7, 24), Map.entry(9, 32), Map.entry(6, 53), Map.entry(10, 64));

    public static SystemTable<ColumnContext> create() {
        return ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).addNonNull("table_schema", DataTypes.STRING, r -> r.info.ident().tableIdent().schema()).addNonNull("table_name", DataTypes.STRING, r -> r.info.ident().tableIdent().name()).addNonNull("table_catalog", DataTypes.STRING, r -> r.info.ident().tableIdent().schema()).addNonNull("column_name", DataTypes.STRING, r -> r.info.column().sqlFqn()).addNonNull("ordinal_position", DataTypes.INTEGER, ColumnContext::getOrdinal).addNonNull("data_type", DataTypes.STRING, r -> r.info.valueType().getName()).addNonNull("is_generated", DataTypes.STRING, r -> {
            if (r.info instanceof GeneratedReference) {
                return IS_GENERATED_ALWAYS;
            }
            return IS_GENERATED_NEVER;
        }).addNonNull("is_nullable", DataTypes.BOOLEAN, r -> !r.tableInfo.primaryKey().contains(r.info.column()) && r.info.isNullable()).add("generation_expression", (DataType)DataTypes.STRING, r -> {
            if (r.info instanceof GeneratedReference) {
                return ((GeneratedReference)r.info).formattedGeneratedExpression();
            }
            return null;
        })).add("column_default", (DataType)DataTypes.STRING, r -> {
            Symbol defaultExpression = r.info.defaultExpression();
            if (defaultExpression != null) {
                return defaultExpression.toString();
            }
            return null;
        })).add("character_maximum_length", (DataType)DataTypes.INTEGER, r -> {
            if (r.info.valueType() instanceof StringType) {
                StringType stringType = (StringType)r.info.valueType();
                if (stringType.unbound()) {
                    return null;
                }
                return stringType.lengthLimit();
            }
            return null;
        })).add("character_octet_length", (DataType)DataTypes.INTEGER, ignored -> null)).add("numeric_precision", (DataType)DataTypes.INTEGER, r -> PRECISION_BY_TYPE_ID.get(r.info.valueType().id()))).add("numeric_precision_radix", (DataType)DataTypes.INTEGER, r -> {
            if (DataTypes.isNumericPrimitive(r.info.valueType())) {
                return NUMERIC_PRECISION_RADIX;
            }
            return null;
        })).add("numeric_scale", (DataType)DataTypes.INTEGER, ignored -> null)).add("datetime_precision", (DataType)DataTypes.INTEGER, r -> {
            if (r.info.valueType() == DataTypes.TIMESTAMPZ || r.info.valueType() == DataTypes.TIMESTAMP) {
                return DATETIME_PRECISION;
            }
            return null;
        })).add("interval_type", (DataType)DataTypes.STRING, ignored -> null)).add("interval_precision", (DataType)DataTypes.INTEGER, ignored -> null)).add("character_set_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("character_set_schema", (DataType)DataTypes.STRING, ignored -> null)).add("character_set_name", (DataType)DataTypes.STRING, ignored -> null)).add("collation_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("collation_schema", (DataType)DataTypes.STRING, ignored -> null)).add("collation_name", (DataType)DataTypes.STRING, ignored -> null)).add("domain_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("domain_schema", (DataType)DataTypes.STRING, ignored -> null)).add("domain_name", (DataType)DataTypes.STRING, ignored -> null)).add("udt_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("udt_schema", (DataType)DataTypes.STRING, ignored -> null)).add("udt_name", (DataType)DataTypes.STRING, ignored -> null)).add("check_references", (DataType)DataTypes.STRING, ignored -> null)).add("check_action", (DataType)DataTypes.INTEGER, ignored -> null)).setPrimaryKeys(new ColumnIdent("table_catalog"), new ColumnIdent("table_name"), new ColumnIdent("table_schema"), new ColumnIdent("column_name")).build();
    }
}

