/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.functions;

import io.crate.common.collections.Lists2;
import io.crate.metadata.functions.BoundVariables;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.SignatureBindingInfo;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.TypeCompatibility;
import io.crate.types.TypeSignature;
import io.crate.types.UndefinedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;

public class SignatureBinder {
    private static final int SOLVE_ITERATION_LIMIT = 4;
    private static final Logger LOGGER = Loggers.getLogger(SignatureBinder.class, new String[0]);
    private final Signature declaredSignature;
    private final CoercionType coercionType;
    private final Map<String, TypeVariableConstraint> typeVariableConstraints;

    public static SignatureBinder withPrecedenceOnly(Signature declaredSignature) {
        return new SignatureBinder(declaredSignature, CoercionType.PRECEDENCE_ONLY);
    }

    public SignatureBinder(Signature declaredSignature, CoercionType coercionType) {
        this.declaredSignature = declaredSignature;
        this.coercionType = coercionType;
        this.typeVariableConstraints = declaredSignature.getBindingInfo().getTypeVariableConstraints().stream().collect(Collectors.toMap(TypeVariableConstraint::getName, Function.identity()));
    }

    @Nullable
    public Signature bind(List<TypeSignature> actualArgumentTypes) {
        BoundVariables boundVariables = this.bindVariables(actualArgumentTypes);
        if (boundVariables == null) {
            return null;
        }
        return SignatureBinder.applyBoundVariables(this.declaredSignature, boundVariables, this.typeVariableConstraints, actualArgumentTypes.size());
    }

    @Nullable
    public BoundVariables bindVariables(List<TypeSignature> actualArgumentTypes) {
        ArrayList<TypeConstraintSolver> constraintSolvers = new ArrayList<TypeConstraintSolver>();
        if (!this.appendConstraintSolversForArguments(constraintSolvers, actualArgumentTypes)) {
            return null;
        }
        return this.iterativeSolve(Collections.unmodifiableList(constraintSolvers));
    }

    @Nullable
    private static Signature applyBoundVariables(Signature signature, BoundVariables boundVariables, Map<String, TypeVariableConstraint> typeVariableConstraints, int arity) {
        List<TypeSignature> argumentSignatures;
        SignatureBindingInfo bindingInfo = signature.getBindingInfo();
        assert (bindingInfo != null) : "Expecting the signature's binding info to be not null";
        if (bindingInfo.isVariableArity()) {
            argumentSignatures = SignatureBinder.expandVarargFormalTypeSignature(signature.getArgumentTypes(), bindingInfo.getVariableArityGroup(), typeVariableConstraints, arity);
            if (argumentSignatures == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Size of argument types does not match a multiple of the defined variable arguments");
                }
                return null;
            }
        } else {
            if (signature.getArgumentTypes().size() != arity) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Size of argument types does not match given arity");
                }
                return null;
            }
            argumentSignatures = signature.getArgumentTypes();
        }
        List<TypeSignature> boundArgumentSignatures = SignatureBinder.applyBoundVariables(argumentSignatures, boundVariables);
        TypeSignature boundReturnTypeSignature = SignatureBinder.applyBoundVariables(signature.getReturnType(), boundVariables);
        return Signature.builder().name(signature.getName()).kind(signature.getKind()).argumentTypes(boundArgumentSignatures).returnType(boundReturnTypeSignature).setVariableArity(false).build();
    }

    private static List<TypeSignature> applyBoundVariables(List<TypeSignature> typeSignatures, BoundVariables boundVariables) {
        ArrayList<TypeSignature> builder = new ArrayList<TypeSignature>();
        for (TypeSignature typeSignature : typeSignatures) {
            builder.add(SignatureBinder.applyBoundVariables(typeSignature, boundVariables));
        }
        return Collections.unmodifiableList(builder);
    }

    private static TypeSignature applyBoundVariables(TypeSignature typeSignature, BoundVariables boundVariables) {
        String baseType = typeSignature.getBaseTypeName();
        if (boundVariables.containsTypeVariable(baseType)) {
            if (!typeSignature.getParameters().isEmpty()) {
                throw new IllegalStateException("Type parameters cannot have parameters");
            }
            TypeSignature boundTS = boundVariables.getTypeVariable(baseType).getTypeSignature();
            if (typeSignature instanceof ParameterTypeSignature) {
                return new ParameterTypeSignature(((ParameterTypeSignature)typeSignature).parameterName(), boundTS);
            }
            return boundTS;
        }
        List<TypeSignature> parameters = Lists2.map(typeSignature.getParameters(), typeSignatureParameter -> SignatureBinder.applyBoundVariables(typeSignatureParameter, boundVariables));
        if (typeSignature instanceof ParameterTypeSignature) {
            return new ParameterTypeSignature(((ParameterTypeSignature)typeSignature).parameterName(), new TypeSignature(baseType, parameters));
        }
        return new TypeSignature(baseType, parameters);
    }

    private boolean appendConstraintSolversForArguments(List<TypeConstraintSolver> resultBuilder, List<TypeSignature> actualTypeSignatures) {
        SignatureBindingInfo declaredBindingInfo = this.declaredSignature.getBindingInfo();
        assert (declaredBindingInfo != null) : "Expecting the signature's binding info to be not null";
        boolean variableArity = declaredBindingInfo.isVariableArity();
        List<TypeSignature> formalTypeSignatures = this.declaredSignature.getArgumentTypes();
        if (variableArity) {
            int variableArgumentCount;
            int variableGroupCount = declaredBindingInfo.getVariableArityGroup().size();
            int n = variableArgumentCount = variableGroupCount > 0 ? variableGroupCount : 1;
            if (actualTypeSignatures.size() <= formalTypeSignatures.size() - variableArgumentCount) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Given signature size {} is not smaller than minimum variableArity of formal signature size {}", (Object)actualTypeSignatures.size(), (Object)(formalTypeSignatures.size() - variableArgumentCount));
                }
                return false;
            }
            if ((formalTypeSignatures = SignatureBinder.expandVarargFormalTypeSignature(formalTypeSignatures, declaredBindingInfo.getVariableArityGroup(), this.typeVariableConstraints, actualTypeSignatures.size())) == null) {
                return false;
            }
        }
        if (formalTypeSignatures.size() != actualTypeSignatures.size()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Given signature size {} does not match formal signature size {}", (Object)actualTypeSignatures.size(), (Object)formalTypeSignatures.size());
            }
            return false;
        }
        for (int i = 0; i < formalTypeSignatures.size(); ++i) {
            this.appendTypeRelationshipConstraintSolver(resultBuilder, formalTypeSignatures.get(i), actualTypeSignatures.get(i), this.coercionType);
        }
        return this.appendConstraintSolvers(resultBuilder, formalTypeSignatures, actualTypeSignatures, this.coercionType);
    }

    private boolean appendConstraintSolvers(List<TypeConstraintSolver> resultBuilder, List<? extends TypeSignature> formalTypeSignatures, List<TypeSignature> actualTypeSignatures, CoercionType coercionType) {
        if (formalTypeSignatures.size() != actualTypeSignatures.size()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Given signature size {} does not match formal signature size {}", (Object)actualTypeSignatures.size(), (Object)formalTypeSignatures.size());
            }
            return false;
        }
        for (int i = 0; i < formalTypeSignatures.size(); ++i) {
            if (this.appendConstraintSolvers(resultBuilder, formalTypeSignatures.get(i), actualTypeSignatures.get(i), coercionType)) continue;
            return false;
        }
        return true;
    }

    private boolean appendConstraintSolvers(List<TypeConstraintSolver> resultBuilder, TypeSignature formalTypeSignature, TypeSignature actualTypeSignature, CoercionType coercionType) {
        if (formalTypeSignature.getParameters().isEmpty()) {
            TypeVariableConstraint typeVariableConstraint = this.typeVariableConstraints.get(formalTypeSignature.getBaseTypeName());
            if (typeVariableConstraint == null) {
                return true;
            }
            resultBuilder.add(new TypeParameterSolver(formalTypeSignature.getBaseTypeName(), actualTypeSignature.createType()));
            return true;
        }
        DataType<?> actualType = actualTypeSignature.createType();
        List<TypeSignature> actualTypeParametersTypeSignature = 0 == actualType.id() ? Collections.nCopies(formalTypeSignature.getParameters().size(), UndefinedType.INSTANCE.getTypeSignature()) : Lists2.map(actualType.getTypeParameters(), DataType::getTypeSignature);
        return this.appendConstraintSolvers(resultBuilder, Collections.unmodifiableList(formalTypeSignature.getParameters()), actualTypeParametersTypeSignature, coercionType);
    }

    private void appendTypeRelationshipConstraintSolver(List<TypeConstraintSolver> resultBuilder, TypeSignature formalTypeSignature, TypeSignature actualTypeSignature, CoercionType coercionType) {
        Set<String> typeVariables = this.typeVariablesOf(formalTypeSignature);
        resultBuilder.add(new TypeRelationshipConstraintSolver(formalTypeSignature, typeVariables, actualTypeSignature.createType(), coercionType));
    }

    private Set<String> typeVariablesOf(TypeSignature typeSignature) {
        if (this.typeVariableConstraints.containsKey(typeSignature.getBaseTypeName())) {
            return Set.of(typeSignature.getBaseTypeName());
        }
        HashSet<String> variables = new HashSet<String>();
        for (TypeSignature parameter : typeSignature.getParameters()) {
            variables.addAll(this.typeVariablesOf(parameter));
        }
        return variables;
    }

    @Nullable
    private BoundVariables iterativeSolve(List<TypeConstraintSolver> constraints) {
        BoundVariables.Builder boundVariablesBuilder = BoundVariables.builder();
        int i = 0;
        block5: while (true) {
            if (i == 4) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "SignatureBinder.iterativeSolve does not converge after %d iterations.", 4));
            }
            SolverReturnStatusMerger statusMerger = new SolverReturnStatusMerger();
            for (TypeConstraintSolver constraint : constraints) {
                SolverReturnStatus constraintStatus = constraint.update(boundVariablesBuilder);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Status after updating constraint={}: {}", (Object)constraint, (Object)constraintStatus);
                }
                statusMerger.add(constraintStatus);
                if (statusMerger.getCurrent() != SolverReturnStatus.UNSOLVABLE) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Status merger resulted in UNSOLVABLE state");
                }
                return null;
            }
            switch (statusMerger.getCurrent()) {
                case UNCHANGED_SATISFIED: {
                    break block5;
                }
                case UNCHANGED_NOT_SATISFIED: {
                    return null;
                }
                case CHANGED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Signature binding unsolvable");
                }
            }
            ++i;
        }
        BoundVariables boundVariables = boundVariablesBuilder.build();
        if (!this.allTypeVariablesBound(boundVariables)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Not all variables are bound. Defined variables={}, bound={}", this.typeVariableConstraints, (Object)boundVariables);
            }
            return null;
        }
        return boundVariables;
    }

    private boolean allTypeVariablesBound(BoundVariables boundVariables) {
        return boundVariables.getTypeVariableNames().equals(this.typeVariableConstraints.keySet());
    }

    @Nullable
    private static List<TypeSignature> expandVarargFormalTypeSignature(List<TypeSignature> formalTypeSignatures, List<TypeSignature> variableArityGroup, Map<String, TypeVariableConstraint> typeVariableConstraints, int actualArity) {
        int variableArityGroupCount = variableArityGroup.size();
        if (variableArityGroupCount > 0 && actualArity % variableArityGroupCount != 0) {
            return null;
        }
        int arityCountIncludedInsideFormalSignature = variableArityGroupCount == 0 ? 1 : variableArityGroupCount;
        int variableArityArgumentsCount = actualArity - formalTypeSignatures.size() + arityCountIncludedInsideFormalSignature;
        if (variableArityArgumentsCount == 0) {
            return formalTypeSignatures.subList(0, formalTypeSignatures.size() - arityCountIncludedInsideFormalSignature);
        }
        if (variableArityArgumentsCount == arityCountIncludedInsideFormalSignature) {
            return formalTypeSignatures;
        }
        if (variableArityArgumentsCount > arityCountIncludedInsideFormalSignature && formalTypeSignatures.isEmpty()) {
            throw new IllegalArgumentException("Found variable argument(s) but list of formal type signatures is empty");
        }
        ArrayList<TypeSignature> builder = new ArrayList<TypeSignature>(formalTypeSignatures);
        if (variableArityGroup.isEmpty()) {
            TypeSignature lastTypeSignature = formalTypeSignatures.get(formalTypeSignatures.size() - 1);
            for (int i = 1; i < variableArityArgumentsCount; ++i) {
                SignatureBinder.addVarArgTypeSignature(lastTypeSignature, typeVariableConstraints, builder, i);
            }
        } else {
            int i = 0;
            while (i < variableArityArgumentsCount - formalTypeSignatures.size()) {
                i += variableArityGroupCount;
                for (TypeSignature typeSignature : variableArityGroup) {
                    SignatureBinder.addVarArgTypeSignature(typeSignature, typeVariableConstraints, builder, i);
                }
            }
        }
        return Collections.unmodifiableList(builder);
    }

    private static void addVarArgTypeSignature(TypeSignature typeSignature, Map<String, TypeVariableConstraint> typeVariableConstraints, List<TypeSignature> builder, int actualArity) {
        TypeVariableConstraint typeVariableConstraint = SignatureBinder.resolveTypeVariableConstraint(typeSignature, typeVariableConstraints);
        if (typeVariableConstraint != null && typeVariableConstraint.isAnyAllowed()) {
            String newConstraintName = "_generated_" + typeVariableConstraint + actualArity;
            TypeSignature newTypeSignature = SignatureBinder.replaceTypeVariable(typeSignature, typeVariableConstraint.getName(), newConstraintName);
            typeVariableConstraints.put(newConstraintName, TypeVariableConstraint.typeVariableOfAnyType(newConstraintName));
            builder.add(newTypeSignature);
        } else {
            builder.add(typeSignature);
        }
    }

    @Nullable
    private static TypeVariableConstraint resolveTypeVariableConstraint(TypeSignature signature, Map<String, TypeVariableConstraint> constraints) {
        if (signature.getParameters().isEmpty()) {
            return constraints.get(signature.getBaseTypeName());
        }
        for (TypeSignature parameterSignature : signature.getParameters()) {
            TypeVariableConstraint constraint = SignatureBinder.resolveTypeVariableConstraint(parameterSignature, constraints);
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    private static TypeSignature replaceTypeVariable(TypeSignature signature, String oldVar, String newVar) {
        if (signature.getBaseTypeName().equalsIgnoreCase(oldVar)) {
            return new TypeSignature(newVar, signature.getParameters());
        }
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        for (TypeSignature parameter : signature.getParameters()) {
            parameters.add(SignatureBinder.replaceTypeVariable(parameter, oldVar, newVar));
        }
        return new TypeSignature(signature.getBaseTypeName(), parameters);
    }

    private static boolean satisfiesCoercion(CoercionType coercionType, DataType<?> fromType, TypeSignature toTypeSignature) {
        switch (coercionType) {
            case FULL: {
                return fromType.isConvertableTo(toTypeSignature.createType(), false);
            }
            case PRECEDENCE_ONLY: {
                DataType<?> toType = toTypeSignature.createType();
                return fromType.equals(toType) || fromType.isConvertableTo(toTypeSignature.createType(), false) && toType.precedes(fromType);
            }
        }
        TypeSignature fromTypeSignature = fromType.getTypeSignature();
        if (fromTypeSignature.getBaseTypeName().equals(DataTypes.NUMERIC.getName()) && toTypeSignature.getBaseTypeName().equals(DataTypes.NUMERIC.getName())) {
            return true;
        }
        return fromTypeSignature.equals(toTypeSignature);
    }

    public static enum CoercionType {
        NONE,
        PRECEDENCE_ONLY,
        FULL;

    }

    private static class TypeParameterSolver
    implements TypeConstraintSolver {
        private final String typeParameter;
        private final DataType<?> actualType;

        public TypeParameterSolver(String typeParameter, DataType<?> actualType) {
            this.typeParameter = typeParameter;
            this.actualType = actualType;
        }

        @Override
        public SolverReturnStatus update(BoundVariables.Builder bindings) {
            if (!bindings.containsTypeVariable(this.typeParameter)) {
                bindings.setTypeVariable(this.typeParameter, this.actualType);
                return SolverReturnStatus.CHANGED;
            }
            DataType<?> originalType = bindings.getTypeVariable(this.typeParameter);
            DataType<?> commonType = TypeCompatibility.getCommonType(originalType, this.actualType);
            if (commonType == null) {
                return SolverReturnStatus.UNSOLVABLE;
            }
            if (commonType.equals(originalType)) {
                return SolverReturnStatus.UNCHANGED_SATISFIED;
            }
            bindings.setTypeVariable(this.typeParameter, commonType);
            return SolverReturnStatus.CHANGED;
        }

        public String toString() {
            return "TypeParameterSolver{typeParameter='" + this.typeParameter + "', actualType=" + this.actualType + "}";
        }
    }

    private static class TypeRelationshipConstraintSolver
    implements TypeConstraintSolver {
        private final TypeSignature superTypeSignature;
        private final Set<String> typeVariables;
        private final DataType<?> actualType;
        private final CoercionType coercionType;

        public TypeRelationshipConstraintSolver(TypeSignature superTypeSignature, Set<String> typeVariables, DataType<?> actualType, CoercionType coercionType) {
            this.superTypeSignature = superTypeSignature;
            this.typeVariables = typeVariables;
            this.actualType = actualType;
            this.coercionType = coercionType;
        }

        @Override
        public SolverReturnStatus update(BoundVariables.Builder bindings) {
            for (String variable : this.typeVariables) {
                if (bindings.containsTypeVariable(variable)) continue;
                return SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
            }
            TypeSignature boundSignature = SignatureBinder.applyBoundVariables(this.superTypeSignature, bindings.build());
            if (SignatureBinder.satisfiesCoercion(this.coercionType, this.actualType, boundSignature)) {
                return SolverReturnStatus.UNCHANGED_SATISFIED;
            }
            return SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
        }

        public String toString() {
            return "TypeRelationshipConstraintSolver{superTypeSignature=" + this.superTypeSignature + ", typeVariables=" + this.typeVariables + ", actualType=" + this.actualType + ", allowCoercion=" + this.coercionType + "}";
        }
    }

    private static class SolverReturnStatusMerger {
        private SolverReturnStatus current = SolverReturnStatus.UNCHANGED_SATISFIED;

        private SolverReturnStatusMerger() {
        }

        public void add(SolverReturnStatus newStatus) {
            switch (newStatus) {
                case UNCHANGED_SATISFIED: {
                    break;
                }
                case UNCHANGED_NOT_SATISFIED: {
                    if (this.current != SolverReturnStatus.UNCHANGED_SATISFIED) break;
                    this.current = SolverReturnStatus.UNCHANGED_NOT_SATISFIED;
                    break;
                }
                case CHANGED: {
                    if (this.current != SolverReturnStatus.UNCHANGED_SATISFIED && this.current != SolverReturnStatus.UNCHANGED_NOT_SATISFIED) break;
                    this.current = SolverReturnStatus.CHANGED;
                    break;
                }
                default: {
                    this.current = SolverReturnStatus.UNSOLVABLE;
                }
            }
        }

        public SolverReturnStatus getCurrent() {
            return this.current;
        }
    }

    private static interface TypeConstraintSolver {
        public SolverReturnStatus update(BoundVariables.Builder var1);
    }

    private static enum SolverReturnStatus {
        UNCHANGED_SATISFIED,
        UNCHANGED_NOT_SATISFIED,
        CHANGED,
        UNSOLVABLE;

    }
}

