/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.functions;

import io.crate.common.collections.EnumSets;
import io.crate.common.collections.Lists2;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.SignatureBindingInfo;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class Signature
implements Writeable {
    private final FunctionName name;
    private final FunctionType kind;
    private final List<TypeSignature> argumentTypes;
    private final TypeSignature returnType;
    private final Set<Scalar.Feature> features;
    @Nullable
    private final SignatureBindingInfo bindingInfo;

    public static Signature aggregate(String name, TypeSignature ... types) {
        return Signature.aggregate(new FunctionName(null, name), types);
    }

    public static Signature aggregate(FunctionName name, TypeSignature ... types) {
        return Signature.signatureBuilder(name, FunctionType.AGGREGATE, types).build();
    }

    public static Signature scalar(String name, TypeSignature ... types) {
        return Signature.scalar(new FunctionName(null, name), types);
    }

    public static Signature table(FunctionName name, TypeSignature ... types) {
        return Signature.signatureBuilder(name, FunctionType.TABLE, types).build();
    }

    public static Signature table(String name, TypeSignature ... types) {
        return Signature.table(new FunctionName(null, name), types);
    }

    public static Signature window(FunctionName name, TypeSignature ... types) {
        return Signature.signatureBuilder(name, FunctionType.WINDOW, types).build();
    }

    public static Signature window(String name, TypeSignature ... types) {
        return Signature.window(new FunctionName(null, name), types);
    }

    public static Signature scalar(FunctionName name, TypeSignature ... types) {
        return Signature.signatureBuilder(name, FunctionType.SCALAR, types).build();
    }

    private static Builder signatureBuilder(FunctionName name, FunctionType type, TypeSignature ... types) {
        assert (types.length > 0) : "Types must contain at least the return type (last element), 0 types given";
        Builder builder = Signature.builder().name(name).kind(type).returnType(types[types.length - 1]);
        if (types.length > 1) {
            builder.argumentTypes(Arrays.copyOf(types, types.length - 1));
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Signature signature) {
        return new Builder(signature);
    }

    private Signature(FunctionName name, FunctionType kind, List<TypeVariableConstraint> typeVariableConstraints, List<TypeSignature> argumentTypes, TypeSignature returnType, Set<Scalar.Feature> features, List<TypeSignature> variableArityGroup, boolean variableArity, boolean allowCoercion) {
        this.name = name;
        this.kind = kind;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.features = features;
        this.bindingInfo = new SignatureBindingInfo(typeVariableConstraints, variableArityGroup, variableArity, allowCoercion);
    }

    public Signature(StreamInput in) throws IOException {
        this.name = new FunctionName(in);
        this.kind = FunctionType.values()[in.readVInt()];
        int argsSize = in.readVInt();
        this.argumentTypes = new ArrayList<TypeSignature>(argsSize);
        for (int i = 0; i < argsSize; ++i) {
            this.argumentTypes.add(TypeSignature.fromStream(in));
        }
        this.returnType = TypeSignature.fromStream(in);
        int enumElements = in.readVInt();
        this.features = Collections.unmodifiableSet(EnumSets.unpackFromInt(enumElements, Scalar.Feature.class));
        this.bindingInfo = null;
    }

    public Signature withTypeVariableConstraints(TypeVariableConstraint ... typeVariableConstraints) {
        return Signature.builder(this).typeVariableConstraints(typeVariableConstraints).build();
    }

    public Signature withVariableArity() {
        return Signature.builder(this).setVariableArity(true).build();
    }

    public Signature withForbiddenCoercion() {
        return Signature.builder(this).forbidCoercion().build();
    }

    public Signature withFeatures(Set<Scalar.Feature> features) {
        return Signature.builder(this).features(features).build();
    }

    public FunctionName getName() {
        return this.name;
    }

    public FunctionType getKind() {
        return this.kind;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public List<DataType<?>> getArgumentDataTypes() {
        return Lists2.map(this.argumentTypes, TypeSignature::createType);
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public Set<Scalar.Feature> getFeatures() {
        return this.features;
    }

    public boolean hasFeature(Scalar.Feature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean isDeterministic() {
        return this.hasFeature(Scalar.Feature.DETERMINISTIC);
    }

    @Nullable
    public SignatureBindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.name.writeTo(out);
        out.writeVInt(this.kind.ordinal());
        out.writeVInt(this.argumentTypes.size());
        for (TypeSignature typeSignature : this.argumentTypes) {
            TypeSignature.toStream(typeSignature, out);
        }
        TypeSignature.toStream(this.returnType, out);
        out.writeVInt(EnumSets.packToInt(this.features));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return this.name.equals(signature.name) && this.kind == signature.kind && this.argumentTypes.equals(signature.argumentTypes) && this.returnType.equals(signature.returnType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.argumentTypes, this.returnType});
    }

    public String toString() {
        List<Object> allConstraints = List.of();
        if (this.bindingInfo != null) {
            allConstraints = Lists2.map(this.bindingInfo.getTypeVariableConstraints(), TypeVariableConstraint::toString);
        }
        return this.name + (String)(allConstraints.isEmpty() ? "" : "<" + String.join((CharSequence)",", allConstraints) + ">") + "(" + Lists2.joinOn(",", this.argumentTypes, TypeSignature::toString) + "):" + this.returnType;
    }

    public static class Builder {
        private FunctionName name;
        private FunctionType kind;
        private List<TypeSignature> argumentTypes = Collections.emptyList();
        private TypeSignature returnType;
        private Set<Scalar.Feature> features = Scalar.DETERMINISTIC_ONLY;
        private List<TypeVariableConstraint> typeVariableConstraints = Collections.emptyList();
        private List<TypeSignature> variableArityGroup = Collections.emptyList();
        private boolean variableArity = false;
        private boolean allowCoercion = true;

        public Builder() {
        }

        public Builder(Signature signature) {
            this.name = signature.getName();
            this.kind = signature.getKind();
            this.argumentTypes = signature.getArgumentTypes();
            this.returnType = signature.getReturnType();
            this.features = signature.getFeatures();
            if (signature.getBindingInfo() != null) {
                this.typeVariableConstraints = signature.getBindingInfo().getTypeVariableConstraints();
                this.variableArityGroup = signature.getBindingInfo().getVariableArityGroup();
                this.variableArity = signature.getBindingInfo().isVariableArity();
                this.allowCoercion = signature.getBindingInfo().isCoercionAllowed();
            }
        }

        public Builder name(String name) {
            return this.name(new FunctionName(null, name));
        }

        public Builder name(FunctionName name) {
            this.name = name;
            return this;
        }

        public Builder kind(FunctionType kind) {
            this.kind = kind;
            return this;
        }

        public Builder argumentTypes(TypeSignature ... argumentTypes) {
            return this.argumentTypes(List.of(argumentTypes));
        }

        public Builder argumentTypes(List<TypeSignature> argumentTypes) {
            this.argumentTypes = argumentTypes;
            return this;
        }

        public Builder returnType(TypeSignature returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder features(Set<Scalar.Feature> features) {
            this.features = features;
            return this;
        }

        public Builder typeVariableConstraints(TypeVariableConstraint ... typeVariableConstraints) {
            return this.typeVariableConstraints(List.of(typeVariableConstraints));
        }

        public Builder typeVariableConstraints(List<TypeVariableConstraint> typeVariableConstraints) {
            this.typeVariableConstraints = typeVariableConstraints;
            return this;
        }

        public Builder variableArityGroup(List<TypeSignature> variableArityGroup) {
            this.variableArityGroup = variableArityGroup;
            this.variableArity = !variableArityGroup.isEmpty();
            return this;
        }

        public Builder setVariableArity(boolean variableArity) {
            this.variableArity = variableArity;
            return this;
        }

        public Builder forbidCoercion() {
            this.allowCoercion = false;
            return this;
        }

        public Signature build() {
            assert (this.name != null) : "Signature requires the 'name' to be set";
            assert (this.kind != null) : "Signature requires the 'kind' to be set";
            assert (this.returnType != null) : "Signature requires the 'returnType' to be set";
            return new Signature(this.name, this.kind, this.typeVariableConstraints, this.argumentTypes, this.returnType, this.features, this.variableArityGroup, this.variableArity, this.allowCoercion);
        }
    }
}

