/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.functions;

import io.crate.types.DataType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BoundVariables {
    private final Map<String, DataType<?>> typeVariables;

    public BoundVariables(Map<String, DataType<?>> typeVariables) {
        this.typeVariables = Map.copyOf(typeVariables);
    }

    public DataType<?> getTypeVariable(String variableName) {
        return this.typeVariables.get(variableName);
    }

    public boolean containsTypeVariable(String variableName) {
        return this.typeVariables.containsKey(variableName);
    }

    public Set<String> getTypeVariableNames() {
        return this.typeVariables.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundVariables that = (BoundVariables)o;
        return Objects.equals(this.typeVariables, that.typeVariables);
    }

    public int hashCode() {
        return Objects.hash(this.typeVariables);
    }

    public String toString() {
        return "BoundVariables{typeVariables=" + this.typeVariables + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, DataType<?>> typeVariables = new HashMap();

        public DataType<?> getTypeVariable(String variableName) {
            return this.typeVariables.get(variableName);
        }

        public void setTypeVariable(String variableName, DataType<?> variableValue) {
            this.typeVariables.put(variableName, variableValue);
        }

        public boolean containsTypeVariable(String variableName) {
            return this.typeVariables.containsKey(variableName);
        }

        public BoundVariables build() {
            return new BoundVariables(this.typeVariables);
        }
    }
}

