/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.UnhandledServerException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocIndexMetadata;
import io.crate.metadata.doc.DocTableInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;

public class DocTableInfoBuilder {
    private final RelationName ident;
    private final ClusterState state;
    private final NodeContext nodeCtx;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Metadata metadata;
    private String[] concreteIndices;
    private String[] concreteOpenIndices;
    private static final Logger LOGGER = LogManager.getLogger(DocTableInfoBuilder.class);

    public DocTableInfoBuilder(NodeContext nodeCtx, RelationName ident, ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.nodeCtx = nodeCtx;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.ident = ident;
        this.state = state;
        this.metadata = state.metadata();
    }

    private DocIndexMetadata docIndexMetadata() {
        DocIndexMetadata docIndexMetadata;
        String templateName = PartitionName.templateName(this.ident.schema(), this.ident.name());
        if (this.metadata.getTemplates().containsKey(templateName)) {
            docIndexMetadata = this.buildDocIndexMetadataFromTemplate(this.ident.indexNameOrAlias(), templateName);
            this.concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.state, IndicesOptions.lenientExpandOpen(), this.ident.indexNameOrAlias());
            this.concreteOpenIndices = this.indexNameExpressionResolver.concreteIndexNames(this.state, IndicesOptions.fromOptions(true, true, true, false, IndicesOptions.strictExpandOpenAndForbidClosed()), this.ident.indexNameOrAlias());
        } else {
            try {
                this.concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.state, IndicesOptions.strictExpandOpen(), this.ident.indexNameOrAlias());
                this.concreteOpenIndices = this.concreteIndices;
                if (this.concreteIndices.length == 0) {
                    throw new RelationUnknown(this.ident);
                }
                docIndexMetadata = this.buildDocIndexMetadata(this.concreteIndices[0]);
            }
            catch (IndexNotFoundException ex) {
                throw new RelationUnknown(this.ident.fqn(), ex);
            }
        }
        return docIndexMetadata;
    }

    private DocIndexMetadata buildDocIndexMetadata(String indexName) {
        DocIndexMetadata docIndexMetadata;
        IndexMetadata indexMetadata = this.metadata.index(indexName);
        try {
            docIndexMetadata = new DocIndexMetadata(this.nodeCtx, indexMetadata, this.ident);
        }
        catch (IOException e) {
            throw new UnhandledServerException("Unable to build DocIndexMetadata", e);
        }
        try {
            return docIndexMetadata.build();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Could not build DocIndexMetadata from: {}", indexMetadata.mapping().getSourceAsMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private DocIndexMetadata buildDocIndexMetadataFromTemplate(String index, String templateName) {
        DocIndexMetadata docIndexMetadata;
        IndexTemplateMetadata indexTemplateMetadata = this.metadata.getTemplates().get(templateName);
        try {
            IndexMetadata.Builder builder = new IndexMetadata.Builder(index);
            builder.putMapping("default", indexTemplateMetadata.getMappings().get("default").toString());
            Settings.Builder settingsBuilder = Settings.builder().put(indexTemplateMetadata.settings()).put("index.version.created", Version.CURRENT);
            Settings settings = settingsBuilder.build();
            builder.settings(settings);
            builder.numberOfShards(settings.getAsInt("index.number_of_shards", 5));
            builder.numberOfReplicas(settings.getAsInt("index.number_of_replicas", 1));
            docIndexMetadata = new DocIndexMetadata(this.nodeCtx, builder.build(), this.ident);
        }
        catch (IOException e) {
            throw new UnhandledServerException("Unable to build DocIndexMetadata from template", e);
        }
        return docIndexMetadata.build();
    }

    private List<PartitionName> buildPartitions(DocIndexMetadata md) {
        ArrayList<PartitionName> partitions = new ArrayList<PartitionName>();
        if (md.partitionedBy().size() > 0) {
            for (String indexName : this.concreteIndices) {
                if (!IndexParts.isPartitioned(indexName)) continue;
                try {
                    PartitionName partitionName = PartitionName.fromIndexOrTemplate(indexName);
                    assert (partitionName.relationName().equals(this.ident)) : "ident must equal partitionName";
                    partitions.add(partitionName);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn(String.format(Locale.ENGLISH, "Cannot build partition %s of index %s", indexName, this.ident.indexNameOrAlias()));
                }
            }
        }
        return partitions;
    }

    public DocTableInfo build() {
        DocIndexMetadata md = this.docIndexMetadata();
        List<PartitionName> partitions = this.buildPartitions(md);
        return new DocTableInfo(this.ident, md.columns(), md.partitionedByColumns(), (List<GeneratedReference>)md.generatedColumnReferences(), (Collection<ColumnIdent>)md.notNullColumns(), md.indices(), md.references(), md.analyzers(), (List<ColumnIdent>)md.primaryKey(), md.checkConstraints(), md.routingCol(), md.hasAutoGeneratedPrimaryKey(), this.concreteIndices, this.concreteOpenIndices, this.indexNameExpressionResolver, md.numberOfShards(), md.numberOfReplicas(), md.tableParameters(), (List<ColumnIdent>)md.partitionedBy(), partitions, md.columnPolicy(), md.versionCreated(), md.versionUpgraded(), md.isClosed(), md.supportedOperations());
    }
}

