/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.WhereClause;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.sys.TableColumn;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.ShardedTable;
import io.crate.metadata.table.StoredTable;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ColumnPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.settings.Settings;

public class DocTableInfo
implements TableInfo,
ShardedTable,
StoredTable {
    private final Collection<Reference> columns;
    private final List<GeneratedReference> generatedColumns;
    private final List<Reference> partitionedByColumns;
    private final List<Reference> defaultExpressionColumns;
    private final Collection<ColumnIdent> notNullColumns;
    private final Map<ColumnIdent, IndexReference> indexColumns;
    private final Map<ColumnIdent, Reference> references;
    private final Map<ColumnIdent, String> analyzers;
    private final RelationName ident;
    private final List<ColumnIdent> primaryKeys;
    private final List<CheckConstraint<Symbol>> checkConstraints;
    private final ColumnIdent clusteredBy;
    private final String[] concreteIndices;
    private final String[] concreteOpenIndices;
    private final List<ColumnIdent> partitionedBy;
    private final int numberOfShards;
    private final String numberOfReplicas;
    private final Settings tableParameters;
    private final TableColumn docColumn;
    private final Set<Operation> supportedOperations;
    private final List<PartitionName> partitions;
    private final boolean hasAutoGeneratedPrimaryKey;
    private final boolean isPartitioned;
    private final Version versionCreated;
    private final Version versionUpgraded;
    private final boolean closed;
    private final ColumnPolicy columnPolicy;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public DocTableInfo(RelationName ident, Collection<Reference> columns, List<Reference> partitionedByColumns, List<GeneratedReference> generatedColumns, Collection<ColumnIdent> notNullColumns, Map<ColumnIdent, IndexReference> indexColumns, Map<ColumnIdent, Reference> references, Map<ColumnIdent, String> analyzers, List<ColumnIdent> primaryKeys, List<CheckConstraint<Symbol>> checkConstraints, ColumnIdent clusteredBy, boolean hasAutoGeneratedPrimaryKey, String[] concreteIndices, String[] concreteOpenIndices, IndexNameExpressionResolver indexNameExpressionResolver, int numberOfShards, String numberOfReplicas, Settings tableParameters, List<ColumnIdent> partitionedBy, List<PartitionName> partitions, ColumnPolicy columnPolicy, @Nullable Version versionCreated, @Nullable Version versionUpgraded, boolean closed, Set<Operation> supportedOperations) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        assert (partitionedBy.size() == partitionedByColumns.size()) : "partitionedBy and partitionedByColumns must have same amount of items in list";
        this.columns = columns;
        this.partitionedByColumns = partitionedByColumns;
        this.generatedColumns = generatedColumns;
        this.notNullColumns = notNullColumns;
        this.indexColumns = indexColumns;
        this.references = references;
        this.analyzers = analyzers;
        this.ident = ident;
        this.primaryKeys = primaryKeys;
        this.checkConstraints = checkConstraints;
        this.clusteredBy = clusteredBy;
        this.concreteIndices = concreteIndices;
        this.concreteOpenIndices = concreteOpenIndices;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.tableParameters = tableParameters;
        this.hasAutoGeneratedPrimaryKey = hasAutoGeneratedPrimaryKey;
        this.isPartitioned = !partitionedByColumns.isEmpty();
        this.partitionedBy = partitionedBy;
        this.partitions = partitions;
        this.columnPolicy = columnPolicy;
        this.versionCreated = versionCreated;
        this.versionUpgraded = versionUpgraded;
        this.closed = closed;
        this.supportedOperations = supportedOperations;
        this.docColumn = new TableColumn(DocSysColumns.DOC, references);
        this.defaultExpressionColumns = references.values().stream().filter(r -> r.defaultExpression() != null).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Reference getReference(ColumnIdent columnIdent) {
        Reference reference = this.references.get(columnIdent);
        if (reference == null) {
            return this.docColumn.getReference(this.ident(), columnIdent);
        }
        return reference;
    }

    @Override
    public Collection<Reference> columns() {
        return this.columns;
    }

    public List<Reference> defaultExpressionColumns() {
        return this.defaultExpressionColumns;
    }

    public List<GeneratedReference> generatedColumns() {
        return this.generatedColumns;
    }

    @Override
    public RowGranularity rowGranularity() {
        return RowGranularity.DOC;
    }

    @Override
    public RelationName ident() {
        return this.ident;
    }

    @Override
    public Routing getRouting(ClusterState state, RoutingProvider routingProvider, WhereClause whereClause, RoutingProvider.ShardSelection shardSelection, SessionContext sessionContext) {
        String[] indices = whereClause.partitions().isEmpty() ? this.concreteOpenIndices : whereClause.partitions().toArray(new String[0]);
        Map<String, Set<String>> routingMap = null;
        if (!whereClause.clusteredBy().isEmpty()) {
            Set<String> routing = whereClause.routingValues();
            if (routing == null) {
                routing = Collections.emptySet();
            }
            routingMap = this.indexNameExpressionResolver.resolveSearchRouting(state, routing, indices);
        }
        if (routingMap == null) {
            routingMap = Collections.emptyMap();
        }
        return routingProvider.forIndices(state, indices, routingMap, this.isPartitioned, shardSelection);
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return this.primaryKeys;
    }

    @Override
    public List<CheckConstraint<Symbol>> checkConstraints() {
        return this.checkConstraints;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public String numberOfReplicas() {
        return this.numberOfReplicas;
    }

    @Override
    public ColumnIdent clusteredBy() {
        return this.clusteredBy;
    }

    public boolean hasAutoGeneratedPrimaryKey() {
        return this.hasAutoGeneratedPrimaryKey;
    }

    @Override
    public String[] concreteIndices() {
        return this.concreteIndices;
    }

    public String[] concreteOpenIndices() {
        return this.concreteOpenIndices;
    }

    public List<Reference> partitionedByColumns() {
        return this.partitionedByColumns;
    }

    public List<ColumnIdent> partitionedBy() {
        return this.partitionedBy;
    }

    public List<PartitionName> partitions() {
        return this.partitions;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public IndexReference indexColumn(ColumnIdent ident) {
        return this.indexColumns.get(ident);
    }

    public Iterator<IndexReference> indexColumns() {
        return this.indexColumns.values().iterator();
    }

    @Override
    public Iterator<Reference> iterator() {
        return this.references.values().iterator();
    }

    public ColumnPolicy columnPolicy() {
        return this.columnPolicy;
    }

    @Override
    @Nullable
    public Version versionCreated() {
        return this.versionCreated;
    }

    @Override
    @Nullable
    public Version versionUpgraded() {
        return this.versionUpgraded;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Settings parameters() {
        return this.tableParameters;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return this.supportedOperations;
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.BASE_TABLE;
    }

    public String getAnalyzerForColumnIdent(ColumnIdent ident) {
        return this.analyzers.get(ident);
    }

    @Nullable
    public DynamicReference getDynamic(ColumnIdent ident, boolean forWrite) {
        boolean parentIsIgnored = false;
        ColumnPolicy parentPolicy = this.columnPolicy();
        if (!ident.isTopLevel()) {
            Reference parentInfo = null;
            for (ColumnIdent parentIdent = ident.getParent(); parentIdent != null && (parentInfo = this.getReference(parentIdent)) == null; parentIdent = parentIdent.getParent()) {
            }
            if (parentInfo != null) {
                parentPolicy = parentInfo.columnPolicy();
            }
        }
        switch (parentPolicy) {
            case DYNAMIC: {
                if (forWrite) break;
                return null;
            }
            case STRICT: {
                if (forWrite) {
                    throw new ColumnUnknownException(ident.sqlFqn(), this.ident());
                }
                return null;
            }
            case IGNORED: {
                parentIsIgnored = true;
                break;
            }
        }
        if (parentIsIgnored) {
            return new DynamicReference(new ReferenceIdent(this.ident(), ident), this.rowGranularity(), ColumnPolicy.IGNORED);
        }
        return new DynamicReference(new ReferenceIdent(this.ident(), ident), this.rowGranularity());
    }

    public String toString() {
        return this.ident.fqn();
    }

    public Collection<ColumnIdent> notNullColumns() {
        return this.notNullColumns;
    }
}

