/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import io.crate.common.collections.Lists2;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class DocSysColumns {
    public static final ColumnIdent ID = new ColumnIdent("_id");
    public static final ColumnIdent VERSION = new ColumnIdent("_version");
    public static final ColumnIdent SCORE = new ColumnIdent("_score");
    public static final ColumnIdent UID = new ColumnIdent("_uid");
    public static final ColumnIdent DOC = new ColumnIdent("_doc");
    public static final ColumnIdent RAW = new ColumnIdent("_raw");
    public static final ColumnIdent SEQ_NO = new ColumnIdent("_seq_no");
    public static final ColumnIdent PRIMARY_TERM = new ColumnIdent("_primary_term");
    public static final ColumnIdent FETCHID = new ColumnIdent("_fetchid");
    public static final ColumnIdent DOCID = new ColumnIdent("_docid");
    public static final Map<ColumnIdent, DataType<?>> COLUMN_IDENTS = Map.of(DOC, DataTypes.UNTYPED_OBJECT, FETCHID, DataTypes.LONG, ID, DataTypes.STRING, RAW, DataTypes.STRING, SCORE, DataTypes.FLOAT, UID, DataTypes.STRING, VERSION, DataTypes.LONG, DOCID, DataTypes.INTEGER, SEQ_NO, DataTypes.LONG, PRIMARY_TERM, DataTypes.LONG);
    private static final Map<ColumnIdent, String> LUCENE_COLUMN_NAMES = Map.of(RAW, "_source", ID, UID.name());

    private static Reference newInfo(RelationName table, ColumnIdent column, DataType<?> dataType) {
        return new Reference(new ReferenceIdent(table, column), RowGranularity.DOC, dataType, ColumnPolicy.STRICT, Reference.IndexType.NOT_ANALYZED, false, null, null);
    }

    public static void forTable(RelationName relationName, BiConsumer<ColumnIdent, Reference> consumer) {
        for (Map.Entry<ColumnIdent, DataType<?>> entry : COLUMN_IDENTS.entrySet()) {
            ColumnIdent columnIdent = entry.getKey();
            consumer.accept(columnIdent, DocSysColumns.newInfo(relationName, columnIdent, entry.getValue()));
        }
    }

    public static List<Reference> forTable(RelationName relationName) {
        return Lists2.map(COLUMN_IDENTS.entrySet(), e -> DocSysColumns.newInfo(relationName, (ColumnIdent)e.getKey(), (DataType)e.getValue()));
    }

    public static Reference forTable(RelationName table, ColumnIdent column) {
        return DocSysColumns.newInfo(table, column, COLUMN_IDENTS.get(column));
    }

    public static String nameForLucene(ColumnIdent ident) {
        String name = LUCENE_COLUMN_NAMES.get(ident);
        if (name == null) {
            name = ident.name();
        }
        return name;
    }

    public static class Names {
        public static final String ID = "_id";
        public static final String VERSION = "_version";
        public static final String SCORE = "_score";
        public static final String UID = "_uid";
        public static final String DOC = "_doc";
        public static final String RAW = "_raw";
        public static final String SEQ_NO = "_seq_no";
        public static final String PRIMARY_TERM = "_primary_term";
        public static final String FETCHID = "_fetchid";
        public static final String DOCID = "_docid";
    }
}

