/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.blob.v2.BlobIndex;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.metadata.view.ViewInfoFactory;
import io.crate.metadata.view.ViewsMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.Index;

public class DocSchemaInfo
implements SchemaInfo {
    public static final String NAME = "doc";
    private final ClusterService clusterService;
    private final DocTableInfoFactory docTableInfoFactory;
    private final ViewInfoFactory viewInfoFactory;
    private final NodeContext nodeCtx;
    private final UserDefinedFunctionService udfService;
    private final ConcurrentHashMap<String, DocTableInfo> docTableByName = new ConcurrentHashMap();
    public static final Predicate<String> NO_BLOB_NOR_DANGLING = index -> !BlobIndex.isBlobIndex(index) && !IndexParts.isDangling(index);
    private final String schemaName;

    public DocSchemaInfo(String schemaName, ClusterService clusterService, NodeContext nodeCtx, UserDefinedFunctionService udfService, ViewInfoFactory viewInfoFactory, DocTableInfoFactory docTableInfoFactory) {
        this.nodeCtx = nodeCtx;
        this.schemaName = schemaName;
        this.clusterService = clusterService;
        this.udfService = udfService;
        this.viewInfoFactory = viewInfoFactory;
        this.docTableInfoFactory = docTableInfoFactory;
    }

    @Override
    public TableInfo getTableInfo(String name) {
        try {
            return this.docTableByName.computeIfAbsent(name, n -> this.docTableInfoFactory.create(new RelationName(this.schemaName, (String)n), this.clusterService.state()));
        }
        catch (ResourceUnknownException e) {
            return null;
        }
    }

    private Collection<String> tableNames() {
        HashSet<String> tables = new HashSet<String>();
        DocSchemaInfo.extractRelationNamesForSchema(Stream.of(this.clusterService.state().metadata().getConcreteAllIndices()), this.schemaName, tables);
        Iterator<String> templates = this.clusterService.state().metadata().getTemplates().keysIt();
        while (templates.hasNext()) {
            String templateName = templates.next();
            if (!IndexParts.isPartitioned(templateName)) continue;
            try {
                PartitionName partitionName = PartitionName.fromIndexOrTemplate(templateName);
                RelationName ti = partitionName.relationName();
                if (!this.schemaName.equalsIgnoreCase(ti.schema())) continue;
                tables.add(ti.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return tables;
    }

    @Nullable
    private ViewInfo getViewInfo(String name) {
        return this.viewInfoFactory.create(new RelationName(this.schemaName, name), this.clusterService.state());
    }

    private Collection<String> viewNames() {
        ViewsMetadata viewMetadata = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        if (viewMetadata == null) {
            return Collections.emptySet();
        }
        HashSet<String> views = new HashSet<String>();
        DocSchemaInfo.extractRelationNamesForSchema(StreamSupport.stream(viewMetadata.names().spliterator(), false), this.schemaName, views);
        return views;
    }

    private static void extractRelationNamesForSchema(Stream<String> stream, String schema, Set<String> target) {
        stream.filter(NO_BLOB_NOR_DANGLING).map(IndexParts::new).filter(indexParts -> !indexParts.isPartitioned()).filter(indexParts -> indexParts.matchesSchema(schema)).map(IndexParts::getTable).forEach(target::add);
    }

    @Override
    public String name() {
        return this.schemaName;
    }

    @Override
    public void invalidateTableCache(String tableName) {
        this.docTableByName.remove(tableName);
    }

    @Override
    public void update(ClusterChangedEvent event) {
        ImmutableOpenMap<String, IndexTemplateMetadata> prevTemplates;
        assert (event.metadataChanged()) : "metadataChanged must be true if update is called";
        Metadata prevMetadata = event.previousState().metadata();
        for (Index index : event.indicesDeleted()) {
            this.invalidateFromIndex(index, prevMetadata);
        }
        Metadata newMetadata = event.state().metadata();
        for (String index : event.indicesCreated()) {
            this.invalidateAliases(newMetadata.index(index).getAliases());
        }
        ImmutableOpenMap<String, IndexTemplateMetadata> immutableOpenMap = newMetadata.templates();
        if (!immutableOpenMap.equals(prevTemplates = prevMetadata.templates())) {
            for (ObjectCursor cursor : immutableOpenMap.values()) {
                this.invalidateAliases(((IndexTemplateMetadata)cursor.value).aliases());
            }
            for (ObjectCursor cursor : prevTemplates.values()) {
                this.invalidateAliases(((IndexTemplateMetadata)cursor.value).aliases());
            }
        }
        Iterator currentTablesIt = ((ConcurrentHashMap.KeySetView)this.docTableByName.keySet()).iterator();
        ObjectLookupContainer<String> templates = immutableOpenMap.keys();
        ImmutableOpenMap<String, IndexMetadata> indices = newMetadata.indices();
        block4: while (currentTablesIt.hasNext()) {
            String tableName = (String)currentTablesIt.next();
            String indexName = this.getIndexName(tableName);
            IndexMetadata newIndexMetadata = newMetadata.index(indexName);
            if (newIndexMetadata == null) {
                this.docTableByName.remove(tableName);
                continue;
            }
            IndexMetadata oldIndexMetadata = prevMetadata.index(indexName);
            if (oldIndexMetadata != null && ClusterChangedEvent.indexMetadataChanged(oldIndexMetadata, newIndexMetadata)) {
                this.docTableByName.remove(tableName);
                this.invalidateAliases(newIndexMetadata.getAliases());
                this.invalidateAliases(oldIndexMetadata.getAliases());
                continue;
            }
            String possibleTemplateName = PartitionName.templateName(this.name(), tableName);
            if (!templates.contains((Object)possibleTemplateName)) continue;
            for (ObjectObjectCursor<String, IndexMetadata> indexEntry : indices) {
                if (!IndexParts.isPartitioned((String)indexEntry.key)) continue;
                this.docTableByName.remove(tableName);
                continue block4;
            }
        }
        UserDefinedFunctionsMetadata udfMetadata = (UserDefinedFunctionsMetadata)newMetadata.custom("user_defined_functions");
        if (udfMetadata != null) {
            this.udfService.updateImplementations(this.schemaName, udfMetadata.functionsMetadata().stream().filter(f -> this.schemaName.equals(f.schema())));
        }
    }

    @VisibleForTesting
    void invalidateFromIndex(Index index, Metadata metadata) {
        IndexMetadata indexMetadata = metadata.index(index);
        if (indexMetadata != null) {
            this.invalidateAliases(indexMetadata.getAliases());
        }
    }

    private String getIndexName(String tableName) {
        if (this.schemaName.equalsIgnoreCase(NAME)) {
            return tableName;
        }
        return this.schemaName + "." + tableName;
    }

    private void invalidateAliases(ImmutableOpenMap<String, AliasMetadata> aliases) {
        assert (aliases != null) : "aliases must not be null";
        if (aliases.size() > 0) {
            aliases.keysIt().forEachRemaining(this.docTableByName::remove);
        }
    }

    public String toString() {
        return "DocSchemaInfo(" + this.name() + ")";
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return this.tableNames().stream().map(this::getTableInfo).filter(Objects::nonNull)::iterator;
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return this.viewNames().stream().map(this::getViewInfo).filter(Objects::nonNull)::iterator;
    }

    @Override
    public void close() throws Exception {
        this.nodeCtx.functions().deregisterUdfResolversForSchema(this.schemaName);
    }
}

