/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.Templates;
import io.crate.execution.ddl.tables.RenameTableRequest;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexTemplateMissingException;

public class RenameTableClusterStateExecutor {
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    private final Logger logger;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final DDLClusterStateService ddlClusterStateService;
    private final AllocationService allocationService;

    public RenameTableClusterStateExecutor(IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        this.allocationService = allocationService;
        this.logger = LogManager.getLogger(this.getClass());
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.ddlClusterStateService = ddlClusterStateService;
    }

    public ClusterState execute(ClusterState currentState, RenameTableRequest request) throws Exception {
        ClusterBlocks.Builder blocksBuilder;
        RoutingTable.Builder newRoutingTable;
        Metadata.Builder newMetadata;
        RelationName target;
        RelationName source;
        block7: {
            source = request.sourceTableIdent();
            target = request.targetTableIdent();
            boolean isPartitioned = request.isPartitioned();
            Metadata currentMetadata = currentState.getMetadata();
            newMetadata = Metadata.builder(currentMetadata);
            if (isPartitioned) {
                IndexTemplateMetadata indexTemplateMetadata = DDLClusterStateHelpers.templateMetadata(currentMetadata, source);
                if (indexTemplateMetadata == null) {
                    throw new IndexTemplateMissingException("Template for partitioned table is missing");
                }
                RenameTableClusterStateExecutor.renameTemplate(newMetadata, indexTemplateMetadata, target);
            }
            newRoutingTable = RoutingTable.builder(currentState.routingTable());
            blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
            this.logger.info("renaming table '{}' to '{}'", (Object)source.fqn(), (Object)target.fqn());
            try {
                Index[] sourceIndices;
                for (Index sourceIndex : sourceIndices = this.indexNameExpressionResolver.concreteIndices(currentState, STRICT_INDICES_OPTIONS, source.indexNameOrAlias())) {
                    IndexMetadata targetMd;
                    IndexMetadata sourceIndexMetadata = currentMetadata.getIndexSafe(sourceIndex);
                    String sourceIndexName = sourceIndex.getName();
                    newMetadata.remove(sourceIndexName);
                    newRoutingTable.remove(sourceIndexName);
                    blocksBuilder.removeIndexBlocks(sourceIndexName);
                    if (isPartitioned) {
                        PartitionName partitionName = PartitionName.fromIndexOrTemplate(sourceIndexName);
                        String targetIndexName = IndexParts.toIndexName(target, partitionName.ident());
                        targetMd = IndexMetadata.builder(sourceIndexMetadata).removeAllAliases().putAlias(AliasMetadata.builder(target.indexNameOrAlias()).build()).index(targetIndexName).build();
                    } else {
                        targetMd = IndexMetadata.builder(sourceIndexMetadata).index(target.indexNameOrAlias()).build();
                    }
                    newMetadata.put(targetMd, true);
                    newRoutingTable.addAsFromCloseToOpen(targetMd);
                    blocksBuilder.addBlocks(targetMd);
                }
            }
            catch (IndexNotFoundException e) {
                if (isPartitioned) break block7;
                throw e;
            }
        }
        ClusterState clusterStateAfterRename = ClusterState.builder(currentState).metadata(newMetadata).routingTable(newRoutingTable.build()).blocks(blocksBuilder).build();
        return this.allocationService.reroute(this.ddlClusterStateService.onRenameTable(clusterStateAfterRename, source, target, request.isPartitioned()), "rename-table");
    }

    private static void renameTemplate(Metadata.Builder newMetadata, IndexTemplateMetadata sourceTemplateMetadata, RelationName target) {
        IndexTemplateMetadata.Builder updatedTemplate = Templates.copyWithNewName(sourceTemplateMetadata, target);
        newMetadata.removeTemplate(sourceTemplateMetadata.getName()).put(updatedTemplate);
    }
}

