/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.OpenCloseTableOrPartitionRequest;
import io.crate.metadata.cluster.AbstractOpenCloseTableClusterStateTaskExecutor;
import io.crate.metadata.cluster.DDLClusterStateService;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;

public class OpenTableClusterStateTaskExecutor
extends AbstractOpenCloseTableClusterStateTaskExecutor {
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final IndicesService indicesService;

    public OpenTableClusterStateTaskExecutor(IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, IndicesService indexServices) {
        super(indexNameExpressionResolver, allocationService, ddlClusterStateService);
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.indicesService = indexServices;
    }

    @Override
    protected IndexMetadata.State indexState() {
        return IndexMetadata.State.OPEN;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, OpenCloseTableOrPartitionRequest request) throws Exception {
        AbstractOpenCloseTableClusterStateTaskExecutor.Context context = this.prepare(currentState, request);
        Set<IndexMetadata> indicesToOpen = context.indicesMetadata();
        IndexTemplateMetadata templateMetadata = context.templateMetadata();
        if (indicesToOpen.isEmpty() && templateMetadata == null) {
            return currentState;
        }
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
        for (IndexMetadata closedMetadata : indicesToOpen) {
            String indexName = closedMetadata.getIndex().getName();
            blocksBuilder.removeIndexBlockWithId(indexName, 4);
            if (closedMetadata.getState() == IndexMetadata.State.OPEN) continue;
            Settings.Builder updatedSettings = Settings.builder().put(closedMetadata.getSettings());
            updatedSettings.remove(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
            IndexMetadata updatedIndexMetadata = IndexMetadata.builder(closedMetadata).state(IndexMetadata.State.OPEN).settingsVersion(closedMetadata.getSettingsVersion() + 1L).settings(updatedSettings).build();
            updatedIndexMetadata = this.metadataIndexUpgradeService.upgradeIndexMetadata(updatedIndexMetadata, minIndexCompatibilityVersion);
            try {
                this.indicesService.verifyIndexMetadata(updatedIndexMetadata, updatedIndexMetadata);
            }
            catch (Exception e) {
                throw new ElasticsearchException("Failed to verify index " + indexName, (Throwable)e, new Object[0]);
            }
            mdBuilder.put(updatedIndexMetadata, true);
        }
        if (templateMetadata != null) {
            mdBuilder.put(OpenTableClusterStateTaskExecutor.updateOpenCloseOnPartitionTemplate(templateMetadata, true));
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(mdBuilder).blocks(blocksBuilder).build();
        updatedState = context.partitionName() != null ? this.ddlClusterStateService.onOpenTablePartition(updatedState, context.partitionName()) : this.ddlClusterStateService.onOpenTable(updatedState, request.tableIdent());
        RoutingTable.Builder rtBuilder = RoutingTable.builder(updatedState.routingTable());
        for (IndexMetadata index : indicesToOpen) {
            rtBuilder.addAsFromCloseToOpen(updatedState.metadata().getIndexSafe(index.getIndex()));
        }
        return this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rtBuilder.build()).build(), "indices opened " + indicesToOpen);
    }
}

