/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.Arrays;
import java.util.HashSet;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.index.Index;

public class DropTableClusterStateTaskExecutor
extends DDLClusterStateTaskExecutor<DropTableRequest> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final MetadataDeleteIndexService deleteIndexService;
    private final DDLClusterStateService ddlClusterStateService;

    public DropTableClusterStateTaskExecutor(IndexNameExpressionResolver indexNameExpressionResolver, MetadataDeleteIndexService deleteIndexService, DDLClusterStateService ddlClusterStateService) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.deleteIndexService = deleteIndexService;
        this.ddlClusterStateService = ddlClusterStateService;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, DropTableRequest request) throws Exception {
        RelationName relationName = request.tableIdent();
        HashSet<Index> concreteIndices = new HashSet<Index>(Arrays.asList(this.indexNameExpressionResolver.concreteIndices(currentState, IndicesOptions.lenientExpandOpen(), relationName.indexNameOrAlias())));
        currentState = this.deleteIndexService.deleteIndices(currentState, concreteIndices);
        if (request.isPartitioned()) {
            String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
            Metadata.Builder metadata = Metadata.builder(currentState.metadata());
            metadata.removeTemplate(templateName);
            currentState = ClusterState.builder(currentState).metadata(metadata).build();
        }
        currentState = this.ddlClusterStateService.onDropTable(currentState, request.tableIdent());
        return currentState;
    }
}

