/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class DDLClusterStateService {
    private List<DDLClusterStateModifier> clusterStateModifiers = new ArrayList<DDLClusterStateModifier>();

    public void addModifier(DDLClusterStateModifier modifier) {
        this.clusterStateModifiers.add(modifier);
    }

    public ClusterState onCloseTable(ClusterState currentState, RelationName relationName) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onCloseTable((ClusterState)clusterState, relationName));
    }

    public ClusterState onCloseTablePartition(ClusterState currentState, PartitionName partitionName) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onCloseTablePartition((ClusterState)clusterState, partitionName));
    }

    ClusterState onOpenTable(ClusterState currentState, RelationName relationName) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onOpenTable((ClusterState)clusterState, relationName));
    }

    ClusterState onOpenTablePartition(ClusterState currentState, PartitionName partitionName) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onOpenTablePartition((ClusterState)clusterState, partitionName));
    }

    public ClusterState onDropTable(ClusterState currentState, RelationName relationName) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onDropTable((ClusterState)clusterState, relationName));
    }

    ClusterState onRenameTable(ClusterState currentState, RelationName sourceRelationName, RelationName targetRelationName, boolean isPartitioned) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onRenameTable((ClusterState)clusterState, sourceRelationName, targetRelationName, isPartitioned));
    }

    public ClusterState onDropView(ClusterState currentState, List<RelationName> relationNames) {
        return this.applyOnAllModifiers(currentState, (modifier, clusterState) -> modifier.onDropView((ClusterState)clusterState, relationNames));
    }

    public ClusterState onSwapRelations(ClusterState state, RelationName source, RelationName target) {
        return this.applyOnAllModifiers(state, (modifier, currentState) -> modifier.onSwapRelations((ClusterState)currentState, source, target));
    }

    private ClusterState applyOnAllModifiers(ClusterState currentState, BiFunction<DDLClusterStateModifier, ClusterState, ClusterState> function) {
        for (DDLClusterStateModifier modifier : this.clusterStateModifiers) {
            currentState = function.apply(modifier, currentState);
        }
        return currentState;
    }
}

