/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.MapBuilder;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class DDLClusterStateHelpers {
    public static IndexTemplateMetadata updateTemplate(IndexTemplateMetadata indexTemplateMetadata, Map<String, Object> newMappings, Map<String, Object> mappingsToRemove, Settings newSettings, BiConsumer<String, Settings> settingsValidator, Predicate<String> settingsFilter) {
        Map<String, Object> mapping = DDLClusterStateHelpers.removeFromMapping(DDLClusterStateHelpers.mergeTemplateMapping(indexTemplateMetadata, newMappings), mappingsToRemove);
        Settings settings = Settings.builder().put(indexTemplateMetadata.settings()).put(newSettings).normalizePrefix("index.").build().filter(settingsFilter);
        settingsValidator.accept(indexTemplateMetadata.getName(), settings);
        if (mapping.size() != 1 || !mapping.containsKey("default")) {
            mapping = MapBuilder.newMapBuilder().put("default", mapping).map();
        }
        try {
            return new IndexTemplateMetadata.Builder(indexTemplateMetadata).settings(settings).putMapping("default", Strings.toString(XContentFactory.jsonBuilder().map(mapping))).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<IndexMetadata> indexMetadataSetFromIndexNames(Metadata metadata, String[] indices, IndexMetadata.State state) {
        HashSet<IndexMetadata> indicesMetadata = new HashSet<IndexMetadata>();
        for (String indexName : indices) {
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null || indexMetadata.getState() == state) continue;
            indicesMetadata.add(indexMetadata);
        }
        return indicesMetadata;
    }

    @Nullable
    static IndexTemplateMetadata templateMetadata(Metadata metadata, RelationName relationName) {
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        return metadata.templates().get(templateName);
    }

    private static Map<String, Object> removeFromMapping(Map<String, Object> mapping, Map<String, Object> mappingsToRemove) {
        for (String key : mappingsToRemove.keySet()) {
            if (!mapping.containsKey(key)) continue;
            if (mapping.get(key) instanceof Map) {
                mapping.put(key, DDLClusterStateHelpers.removeFromMapping((Map)mapping.get(key), (Map)mappingsToRemove.get(key)));
                continue;
            }
            mapping.remove(key);
        }
        return mapping;
    }

    @VisibleForTesting
    static Map<String, Object> mergeTemplateMapping(IndexTemplateMetadata templateMetadata, Map<String, Object> newMapping) {
        HashMap<String, Object> mergedMapping = new HashMap<String, Object>();
        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : templateMetadata.mappings()) {
            Map<String, Object> mapping = DDLClusterStateHelpers.parseMapping(((CompressedXContent)objectObjectCursor.value).toString());
            Object o = mapping.get("default");
            assert (o instanceof Map) : "o must not be null and must be instance of Map";
            XContentHelper.update(mergedMapping, (Map)o, false);
        }
        XContentHelper.update(mergedMapping, newMapping, false);
        return mergedMapping;
    }

    private static Map<String, Object> parseMapping(String mappingSource) {
        Map<String, Object> map;
        block8: {
            XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappingSource);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to parse mapping", new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }
}

