/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.OpenCloseTableOrPartitionRequest;
import io.crate.metadata.cluster.AbstractOpenCloseTableClusterStateTaskExecutor;
import io.crate.metadata.cluster.DDLClusterStateService;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.index.Index;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;

public class CloseTableClusterStateTaskExecutor
extends AbstractOpenCloseTableClusterStateTaskExecutor {
    public CloseTableClusterStateTaskExecutor(IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        super(indexNameExpressionResolver, allocationService, ddlClusterStateService);
    }

    @Override
    protected IndexMetadata.State indexState() {
        return IndexMetadata.State.CLOSE;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, OpenCloseTableOrPartitionRequest request) throws Exception {
        AbstractOpenCloseTableClusterStateTaskExecutor.Context context = this.prepare(currentState, request);
        Set<Index> indicesToClose = context.indicesMetadata().stream().map(IndexMetadata::getIndex).collect(Collectors.toSet());
        IndexTemplateMetadata templateMetadata = context.templateMetadata();
        if (indicesToClose.isEmpty() && templateMetadata == null) {
            return currentState;
        }
        Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, indicesToClose);
        if (!restoringIndices.isEmpty()) {
            throw new IllegalArgumentException("Cannot close indices that are being restored: " + restoringIndices);
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToClose);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot close indices that are being snapshotted: " + snapshottingIndices + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        for (IndexMetadata openIndexMetadata : context.indicesMetadata()) {
            String indexName = openIndexMetadata.getIndex().getName();
            mdBuilder.put(IndexMetadata.builder(openIndexMetadata).state(IndexMetadata.State.CLOSE));
            blocksBuilder.addIndexBlock(indexName, IndexMetadata.INDEX_CLOSED_BLOCK);
        }
        if (templateMetadata != null) {
            mdBuilder.put(CloseTableClusterStateTaskExecutor.updateOpenCloseOnPartitionTemplate(templateMetadata, false));
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(mdBuilder).blocks(blocksBuilder).build();
        updatedState = context.partitionName() != null ? this.ddlClusterStateService.onCloseTablePartition(updatedState, context.partitionName()) : this.ddlClusterStateService.onCloseTable(updatedState, request.tableIdent());
        RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
        for (Index index : indicesToClose) {
            rtBuilder.remove(index.getName());
        }
        return this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rtBuilder.build()).build(), "indices closed " + indicesToClose);
    }
}

