/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.analyze.TableParameters;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.execution.ddl.tables.AlterTableRequest;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.metadata.doc.DocTableInfoBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.ShardLimitValidator;

public class AlterTableClusterStateExecutor
extends DDLClusterStateTaskExecutor<AlterTableRequest> {
    private static final IndicesOptions FIND_OPEN_AND_CLOSED_INDICES_IGNORE_UNAVAILABLE_AND_NON_EXISTING = IndicesOptions.fromOptions(true, true, true, true);
    private final MetadataMappingService metadataMappingService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndexScopedSettings indexScopedSettings;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final ShardLimitValidator shardLimitValidator;
    private final NodeContext nodeContext;

    public AlterTableClusterStateExecutor(MetadataMappingService metadataMappingService, IndicesService indicesService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService metadataCreateIndexService, ShardLimitValidator shardLimitValidator, NodeContext nodeContext) {
        this.metadataMappingService = metadataMappingService;
        this.indicesService = indicesService;
        this.indexScopedSettings = indexScopedSettings;
        this.allocationService = allocationService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.shardLimitValidator = shardLimitValidator;
        this.nodeContext = nodeContext;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, AlterTableRequest request) throws Exception {
        Index[] concreteIndices;
        if (request.isPartitioned()) {
            if (request.partitionIndexName() != null) {
                concreteIndices = this.resolveIndices(currentState, request.partitionIndexName());
                currentState = this.updateMapping(currentState, request, concreteIndices);
                currentState = this.updateSettings(currentState, request.settings(), concreteIndices);
            } else {
                currentState = AlterTableClusterStateExecutor.updateTemplate(currentState, request.tableIdent(), request.settings(), request.mappingDeltaAsMap(), (name, settings) -> AlterTableClusterStateExecutor.validateSettings(name, settings, this.indexScopedSettings, this.metadataCreateIndexService), this.indexScopedSettings);
                if (!request.excludePartitions()) {
                    concreteIndices = this.resolveIndices(currentState, request.tableIdent().indexNameOrAlias());
                    List<String> supportedSettings = TableParameters.PARTITIONED_TABLE_PARAMETER_INFO_FOR_TEMPLATE_UPDATE.supportedSettings().values().stream().map(Setting::getKey).collect(Collectors.toList());
                    supportedSettings.add("index.auto_expand_replicas");
                    currentState = this.updateSettings(currentState, this.filterSettings(request.settings(), supportedSettings), concreteIndices);
                    currentState = this.updateMapping(currentState, request, concreteIndices);
                }
            }
        } else {
            concreteIndices = this.resolveIndices(currentState, request.tableIdent().indexNameOrAlias());
            currentState = this.updateMapping(currentState, request, concreteIndices);
            currentState = this.updateSettings(currentState, request.settings(), concreteIndices);
        }
        DocTableInfoBuilder builder = new DocTableInfoBuilder(this.nodeContext, request.tableIdent(), currentState, this.indexNameExpressionResolver);
        builder.build();
        return currentState;
    }

    private ClusterState updateMapping(ClusterState currentState, AlterTableRequest request, Index[] concreteIndices) throws Exception {
        if (request.mappingDelta() == null) {
            return currentState;
        }
        HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
        for (Index index : concreteIndices) {
            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
            if (indexMapperServices.containsKey(indexMetadata.getIndex())) continue;
            MapperService mapperService = this.indicesService.createIndexMapperService(indexMetadata);
            indexMapperServices.put(index, mapperService);
            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
        }
        PutMappingClusterStateUpdateRequest updateRequest = (PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest(request.mappingDelta()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices);
        return this.metadataMappingService.putMappingExecutor.applyRequest(currentState, updateRequest, indexMapperServices);
    }

    private ClusterState updateSettings(ClusterState currentState, Settings settings, Index[] concreteIndices) {
        Settings finalSettings;
        Settings.Builder indexSettings;
        Settings.Builder updates;
        IndexMetadata indexMetadata;
        Settings normalizedSettings = Settings.builder().put(AlterTableClusterStateExecutor.markArchivedSettings(settings)).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        HashSet<String> skippedSettings = new HashSet<String>();
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        Settings closedSettings = settingsForClosedIndices.build();
        Settings openSettings = settingsForOpenIndices.build();
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        HashSet<Index> openIndices = new HashSet<Index>();
        HashSet<Index> closeIndices = new HashSet<Index>();
        String[] actualIndices = new String[concreteIndices.length];
        for (int i2 = 0; i2 < concreteIndices.length; ++i2) {
            Index index = concreteIndices[i2];
            actualIndices[i2] = index.getName();
            IndexMetadata metadata = currentState.metadata().getIndexSafe(index);
            if (metadata.getState() == IndexMetadata.State.OPEN) {
                openIndices.add(index);
                continue;
            }
            closeIndices.add(index);
        }
        if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
        }
        if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
            int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
            int totalNewShards = openIndices.stream().mapToInt(i -> MetadataUpdateSettingsService.getTotalNewShards(i, currentState, updatedNumberOfReplicas)).sum();
            Optional<String> error = this.shardLimitValidator.checkShardLimit(totalNewShards, currentState);
            if (error.isPresent()) {
                ValidationException ex = new ValidationException();
                ex.addValidationError(error.get());
                throw ex;
            }
            routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
            metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_READ_ONLY_BLOCK, IndexMetadata.INDEX_READ_ONLY_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK, IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_METADATA_BLOCK, IndexMetadata.INDEX_BLOCKS_METADATA_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_WRITE_BLOCK, IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_READ_BLOCK, IndexMetadata.INDEX_BLOCKS_READ_SETTING, openSettings);
        if (!openIndices.isEmpty()) {
            for (Index index : openIndices) {
                indexMetadata = metadataBuilder.getSafe(index);
                updates = Settings.builder();
                indexSettings = Settings.builder().put(indexMetadata.getSettings());
                if (!this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, updates, index.getName())) continue;
                finalSettings = indexSettings.build();
                this.indexScopedSettings.validate(finalSettings.filter(k -> !this.indexScopedSettings.isPrivateSetting((String)k)), true);
                metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
            }
        }
        if (!closeIndices.isEmpty()) {
            for (Index index : closeIndices) {
                indexMetadata = metadataBuilder.getSafe(index);
                updates = Settings.builder();
                indexSettings = Settings.builder().put(indexMetadata.getSettings());
                if (!this.indexScopedSettings.updateSettings(closedSettings, indexSettings, updates, index.getName())) continue;
                finalSettings = indexSettings.build();
                this.indexScopedSettings.validate(finalSettings.filter(k -> !this.indexScopedSettings.isPrivateSetting((String)k)), true);
                metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
            }
        }
        for (String index : actualIndices) {
            if (IndexSettings.same(currentState.metadata().index(index).getSettings(), metadataBuilder.get(index).getSettings())) continue;
            IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(index));
            builder.settingsVersion(1L + builder.settingsVersion());
            metadataBuilder.put(builder);
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
        updatedState = this.allocationService.reroute(updatedState, "settings update");
        try {
            IndexMetadata updatedMetadata;
            IndexMetadata currentMetadata;
            for (Index index : openIndices) {
                currentMetadata = currentState.getMetadata().getIndexSafe(index);
                updatedMetadata = updatedState.metadata().getIndexSafe(index);
                this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
            }
            for (Index index : closeIndices) {
                currentMetadata = currentState.getMetadata().getIndexSafe(index);
                updatedMetadata = updatedState.metadata().getIndexSafe(index);
                this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
            }
        }
        catch (IOException ex) {
            throw ExceptionsHelper.convertToElastic(ex);
        }
        return updatedState;
    }

    static ClusterState updateTemplate(ClusterState currentState, RelationName relationName, Settings newSetting, Map<String, Object> newMapping, BiConsumer<String, Settings> settingsValidator, IndexScopedSettings indexScopedSettings) throws IOException {
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        IndexTemplateMetadata indexTemplateMetadata = currentState.metadata().templates().get(templateName);
        IndexTemplateMetadata newIndexTemplateMetadata = DDLClusterStateHelpers.updateTemplate(indexTemplateMetadata, newMapping, Collections.emptyMap(), newSetting, settingsValidator, (String k) -> !indexScopedSettings.isPrivateSetting((String)k));
        Metadata.Builder metadata = Metadata.builder(currentState.metadata()).put(newIndexTemplateMetadata);
        return ClusterState.builder(currentState).metadata(metadata).build();
    }

    private static void validateSettings(String name, Settings settings, IndexScopedSettings indexScopedSettings, MetadataCreateIndexService metadataCreateIndexService) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        try {
            indexScopedSettings.validate(settings, true);
        }
        catch (IllegalArgumentException iae) {
            validationErrors.add(iae.getMessage());
            for (Throwable t : iae.getSuppressed()) {
                validationErrors.add(t.getMessage());
            }
        }
        List<String> indexSettingsValidation = metadataCreateIndexService.getIndexSettingsValidationErrors(settings, true);
        validationErrors.addAll(indexSettingsValidation);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new InvalidIndexTemplateException(name, validationException.getMessage());
        }
    }

    private Settings filterSettings(Settings settings, List<String> settingsFilter) {
        Settings.Builder settingsBuilder = Settings.builder();
        for (String settingName : settingsFilter) {
            String setting = settings.get(settingName);
            if (setting == null) continue;
            settingsBuilder.put(settingName, setting);
        }
        return settingsBuilder.build();
    }

    private Index[] resolveIndices(ClusterState currentState, String indexExpressions) {
        return this.indexNameExpressionResolver.concreteIndices(currentState, FIND_OPEN_AND_CLOSED_INDICES_IGNORE_UNAVAILABLE_AND_NON_EXISTING, indexExpressions);
    }

    @VisibleForTesting
    static Settings markArchivedSettings(Settings settings) {
        return Settings.builder().put(settings).putNull("archived.*").build();
    }
}

