/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.OpenCloseTableOrPartitionRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractOpenCloseTableClusterStateTaskExecutor
extends DDLClusterStateTaskExecutor<OpenCloseTableOrPartitionRequest> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    final AllocationService allocationService;
    final DDLClusterStateService ddlClusterStateService;

    AbstractOpenCloseTableClusterStateTaskExecutor(IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.allocationService = allocationService;
        this.ddlClusterStateService = ddlClusterStateService;
    }

    protected Context prepare(ClusterState currentState, OpenCloseTableOrPartitionRequest request) {
        RelationName relationName = request.tableIdent();
        String partitionIndexName = request.partitionIndexName();
        Metadata metadata = currentState.metadata();
        String indexToResolve = partitionIndexName != null ? partitionIndexName : relationName.indexNameOrAlias();
        PartitionName partitionName = partitionIndexName != null ? PartitionName.fromIndexOrTemplate(partitionIndexName) : null;
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(currentState, IndicesOptions.lenientExpandOpen(), indexToResolve);
        Set<IndexMetadata> indicesMetadata = DDLClusterStateHelpers.indexMetadataSetFromIndexNames(metadata, concreteIndices, this.indexState());
        IndexTemplateMetadata indexTemplateMetadata = null;
        if (partitionIndexName == null) {
            indexTemplateMetadata = DDLClusterStateHelpers.templateMetadata(metadata, relationName);
        }
        return new Context(indicesMetadata, indexTemplateMetadata, partitionName);
    }

    protected abstract IndexMetadata.State indexState();

    static IndexTemplateMetadata updateOpenCloseOnPartitionTemplate(IndexTemplateMetadata indexTemplateMetadata, boolean openTable) {
        Map<String, Object> metaMap = Collections.singletonMap("_meta", Collections.singletonMap("closed", true));
        if (openTable) {
            return DDLClusterStateHelpers.updateTemplate(indexTemplateMetadata, Collections.emptyMap(), metaMap, Settings.EMPTY, (n, s) -> {}, s -> true);
        }
        return DDLClusterStateHelpers.updateTemplate(indexTemplateMetadata, metaMap, Collections.emptyMap(), Settings.EMPTY, (n, s) -> {}, s -> true);
    }

    protected static class Context {
        private final Set<IndexMetadata> indicesMetadata;
        @Nullable
        private final IndexTemplateMetadata templateMetadata;
        @Nullable
        private final PartitionName partitionName;

        Context(Set<IndexMetadata> indicesMetadata, IndexTemplateMetadata templateMetadata, PartitionName partitionName) {
            this.indicesMetadata = indicesMetadata;
            this.templateMetadata = templateMetadata;
            this.partitionName = partitionName;
        }

        Set<IndexMetadata> indicesMetadata() {
            return this.indicesMetadata;
        }

        @Nullable
        IndexTemplateMetadata templateMetadata() {
            return this.templateMetadata;
        }

        @Nullable
        public PartitionName partitionName() {
            return this.partitionName;
        }
    }
}

