/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.blob;

import io.crate.analyze.NumberOfReplicas;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.RelationName;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.blob.BlobTableInfoFactory;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;

public class InternalBlobTableInfoFactory
implements BlobTableInfoFactory {
    private static final Logger LOGGER = LogManager.getLogger(InternalBlobTableInfoFactory.class);
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Path[] dataFiles;
    private final Path globalBlobPath;

    @Inject
    public InternalBlobTableInfoFactory(Settings settings, IndexNameExpressionResolver indexNameExpressionResolver, Environment environment) {
        this(settings, indexNameExpressionResolver, environment.dataFiles());
    }

    public InternalBlobTableInfoFactory(Settings settings, IndexNameExpressionResolver indexNameExpressionResolver, Path[] dataFiles) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.dataFiles = dataFiles;
        this.globalBlobPath = BlobIndicesService.getGlobalBlobPath(settings);
    }

    private IndexMetadata resolveIndexMetadata(String tableName, ClusterState state) {
        Index index;
        String indexName = BlobIndex.fullIndexName(tableName);
        try {
            index = this.indexNameExpressionResolver.concreteIndices(state, IndicesOptions.strictExpandOpen(), indexName)[0];
        }
        catch (IndexNotFoundException ex) {
            throw new RelationUnknown(indexName, ex);
        }
        return state.metadata().index(index);
    }

    @Override
    public BlobTableInfo create(RelationName ident, ClusterState clusterState) {
        IndexMetadata indexMetadata = this.resolveIndexMetadata(ident.name(), clusterState);
        Settings settings = indexMetadata.getSettings();
        return new BlobTableInfo(ident, indexMetadata.getIndex().getName(), indexMetadata.getNumberOfShards(), NumberOfReplicas.fromSettings(settings), settings, this.blobsPath(settings), IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings), settings.getAsVersion("index.version.upgraded", null), indexMetadata.getState() == IndexMetadata.State.CLOSE);
    }

    private String blobsPath(Settings indexMetadataSettings) {
        Path path;
        String blobsPathStr = BlobIndicesService.SETTING_INDEX_BLOBS_PATH.get(indexMetadataSettings);
        String blobsPath = !Strings.isNullOrEmpty(blobsPathStr) ? blobsPathStr : ((path = this.globalBlobPath) != null ? path.toString() : this.dataFiles[0].toString());
        return blobsPath;
    }
}

