/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.blob;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.TableParameters;
import io.crate.analyze.WhereClause;
import io.crate.common.collections.Tuple;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.ShardedTable;
import io.crate.metadata.table.StoredTable;
import io.crate.metadata.table.TableInfo;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.StringType;
import io.crate.types.TimestampType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.Settings;

public class BlobTableInfo
implements TableInfo,
ShardedTable,
StoredTable {
    private final RelationName ident;
    private final int numberOfShards;
    private final String numberOfReplicas;
    private final String index;
    private final LinkedHashSet<Reference> columns = new LinkedHashSet();
    private final String blobsPath;
    private final TableParameters supportedTableParameters;
    private final Settings tableParameters;
    private final Version versionCreated;
    private final Version versionUpgraded;
    private final boolean closed;
    private final Map<ColumnIdent, Reference> infos = new LinkedHashMap<ColumnIdent, Reference>();
    private static final List<ColumnIdent> PRIMARY_KEY = List.of(new ColumnIdent("digest"));
    private static final List<Tuple<String, DataType>> STATIC_COLUMNS = List.of(new Tuple<String, StringType>("digest", DataTypes.STRING), new Tuple<String, TimestampType>("last_modified", DataTypes.TIMESTAMPZ));

    public BlobTableInfo(RelationName ident, String index, int numberOfShards, String numberOfReplicas, Settings tableParameters, String blobsPath, @Nullable Version versionCreated, @Nullable Version versionUpgraded, boolean closed) {
        assert (ident.indexNameOrAlias().equals(index)) : "RelationName indexName must match index";
        this.ident = ident;
        this.index = index;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.blobsPath = blobsPath;
        this.supportedTableParameters = TableParameters.ALTER_BLOB_TABLE_PARAMETERS;
        this.tableParameters = tableParameters;
        this.versionCreated = versionCreated;
        this.versionUpgraded = versionUpgraded;
        this.closed = closed;
        this.registerStaticColumns();
    }

    @Override
    @Nullable
    public Reference getReference(ColumnIdent columnIdent) {
        return this.infos.get(columnIdent);
    }

    @Override
    public Collection<Reference> columns() {
        return this.columns;
    }

    @Override
    public RowGranularity rowGranularity() {
        return RowGranularity.DOC;
    }

    @Override
    public RelationName ident() {
        return this.ident;
    }

    @Override
    public Routing getRouting(ClusterState state, RoutingProvider routingProvider, WhereClause whereClause, RoutingProvider.ShardSelection shardSelection, SessionContext sessionContext) {
        return routingProvider.forIndices(state, new String[]{this.index}, Collections.emptyMap(), false, shardSelection);
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return PRIMARY_KEY;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public String numberOfReplicas() {
        return this.numberOfReplicas;
    }

    @Override
    @Nullable
    public ColumnIdent clusteredBy() {
        return PRIMARY_KEY.get(0);
    }

    @Override
    public Iterator<Reference> iterator() {
        return this.columns.iterator();
    }

    private void registerStaticColumns() {
        int pos = 0;
        for (Tuple<String, DataType> column : STATIC_COLUMNS) {
            Reference ref = new Reference(new ReferenceIdent(this.ident(), column.v1(), null), RowGranularity.DOC, column.v2(), pos, null);
            assert (ref.column().isTopLevel()) : "only top-level columns should be added to columns list";
            ++pos;
            this.columns.add(ref);
            this.infos.put(ref.column(), ref);
        }
    }

    public String blobsPath() {
        return this.blobsPath;
    }

    public TableParameters tableParameters() {
        return this.supportedTableParameters;
    }

    @Override
    public Settings parameters() {
        return this.tableParameters;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return Operation.BLOB_OPERATIONS;
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.BASE_TABLE;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String[] concreteIndices() {
        return new String[]{this.index};
    }

    @Override
    @Nullable
    public Version versionCreated() {
        return this.versionCreated;
    }

    @Override
    @Nullable
    public Version versionUpgraded() {
        return this.versionUpgraded;
    }
}

