/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.SystemClock;
import io.crate.metadata.settings.SessionSettings;
import java.time.Instant;

public interface TransactionContext {
    public static TransactionContext of(SessionSettings sessionSettings) {
        return new StaticTransactionContext(sessionSettings);
    }

    public Instant currentInstant();

    public SessionSettings sessionSettings();

    public static class StaticTransactionContext
    implements TransactionContext {
        private final SessionSettings sessionSettings;
        private Instant currentInstant;

        StaticTransactionContext(SessionSettings sessionSettings) {
            this.sessionSettings = sessionSettings;
        }

        @Override
        public Instant currentInstant() {
            if (this.currentInstant == null) {
                this.currentInstant = SystemClock.currentInstant();
            }
            return this.currentInstant;
        }

        @Override
        public SessionSettings sessionSettings() {
            return this.sessionSettings;
        }
    }
}

