/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.WhereClause;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.NestableInput;
import io.crate.expression.reference.MapLookupByPathExpression;
import io.crate.expression.symbol.DynamicReference;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.Settings;

public final class SystemTable<T>
implements TableInfo {
    private final RelationName name;
    private final Map<ColumnIdent, Reference> columns;
    private final Map<ColumnIdent, RowCollectExpressionFactory<T>> expressions;
    private final List<ColumnIdent> primaryKeys;
    private final List<Reference> rootColumns;
    private final GetRouting getRouting;
    private final Map<ColumnIdent, Function<ColumnIdent, DynamicReference>> dynamicColumns;
    private final Set<Operation> supportedOperations;
    private final RowGranularity rowGranularity;

    public SystemTable(RelationName name, Map<ColumnIdent, Reference> columns, Map<ColumnIdent, RowCollectExpressionFactory<T>> expressions, List<ColumnIdent> primaryKeys, Map<ColumnIdent, Function<ColumnIdent, DynamicReference>> dynamicColumns, Set<Operation> supportedOperations, RowGranularity rowGranularity, @Nullable GetRouting getRouting) {
        this.name = name;
        this.columns = columns;
        this.supportedOperations = supportedOperations;
        this.rowGranularity = rowGranularity;
        this.getRouting = getRouting == null ? (state, routingProvider, sessionContext) -> Routing.forTableOnSingleNode(name, state.getNodes().getLocalNodeId()) : getRouting;
        this.rootColumns = columns.values().stream().filter(x -> x.column().isTopLevel()).collect(Collectors.toList());
        this.expressions = expressions;
        this.primaryKeys = primaryKeys;
        this.dynamicColumns = dynamicColumns;
    }

    @Override
    @Nullable
    public Reference getReference(ColumnIdent column) {
        return this.getReadReference(column);
    }

    @Override
    @Nullable
    public Reference getReadReference(ColumnIdent column) {
        Reference ref = this.columns.get(column);
        if (ref != null) {
            return ref;
        }
        ColumnIdent parent = column;
        do {
            Function<ColumnIdent, DynamicReference> dynamic;
            if ((dynamic = this.dynamicColumns.get(parent)) == null) continue;
            return dynamic.apply(column);
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    @Override
    public Routing getRouting(ClusterState state, RoutingProvider routingProvider, WhereClause whereClause, RoutingProvider.ShardSelection shardSelection, SessionContext sessionContext) {
        return this.getRouting.getRouting(state, routingProvider, sessionContext);
    }

    @Override
    public Collection<Reference> columns() {
        return this.rootColumns;
    }

    @Override
    public RowGranularity rowGranularity() {
        return this.rowGranularity;
    }

    @Override
    public RelationName ident() {
        return this.name;
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return this.primaryKeys;
    }

    @Override
    public Settings parameters() {
        return Settings.EMPTY;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return this.supportedOperations;
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.BASE_TABLE;
    }

    @Override
    @Nonnull
    public Iterator<Reference> iterator() {
        return this.columns.values().iterator();
    }

    public Map<ColumnIdent, RowCollectExpressionFactory<T>> expressions() {
        return this.expressions;
    }

    public static <T> RelationBuilder<T> builder(RelationName name) {
        return new RelationBuilder(name, RowGranularity.DOC);
    }

    public static <T> RelationBuilder<T> builder(RelationName name, RowGranularity rowGranularity) {
        return new RelationBuilder(name, rowGranularity);
    }

    @FunctionalInterface
    public static interface GetRouting {
        public Routing getRouting(ClusterState var1, RoutingProvider var2, SessionContext var3);
    }

    public static class RelationBuilder<T>
    extends Builder<T> {
        private final RelationName name;
        private final ArrayList<Column<T, ?>> columns = new ArrayList();
        private final RowGranularity rowGranularity;
        private List<ColumnIdent> primaryKeys = List.of();
        private GetRouting getRouting;
        private Set<Operation> supportedOperations = Operation.SYS_READ_ONLY;

        RelationBuilder(RelationName name, RowGranularity rowGranularity) {
            this.name = name;
            this.rowGranularity = rowGranularity;
        }

        public RelationBuilder<T> withRouting(GetRouting getRouting) {
            this.getRouting = getRouting;
            return this;
        }

        public RelationBuilder<T> withSupportedOperations(Set<Operation> supportedOperations) {
            this.supportedOperations = supportedOperations;
            return this;
        }

        @Override
        public <U> RelationBuilder<T> add(String column, DataType<U> type, Function<T, U> getProperty) {
            return this.add((Column)new Column<T, U>(new ColumnIdent(column), type, getProperty));
        }

        public <U> RelationBuilder<T> addNonNull(String column, DataType<U> type, Function<T, U> getProperty) {
            return this.add((Column)new Column<T, U>(new ColumnIdent(column), type, getProperty, false));
        }

        @Override
        protected <U> RelationBuilder<T> add(Column<T, U> column) {
            this.columns.add(column);
            return this;
        }

        public RelationBuilder<T> addDynamicObject(String column, DataType<?> leafType, Function<T, Map<String, Object>> getObject) {
            return this.add(new DynamicColumn<T>(new ColumnIdent(column), leafType, getObject));
        }

        public SystemTable<T> build() {
            HashMap<ColumnIdent, Function<ColumnIdent, DynamicReference>> dynamicColumns = new HashMap<ColumnIdent, Function<ColumnIdent, DynamicReference>>();
            LinkedHashMap<ColumnIdent, Reference> refByColumns = new LinkedHashMap<ColumnIdent, Reference>();
            HashMap expressions = new HashMap();
            this.columns.sort(Comparator.comparing(x -> x.column));
            int rootColIdx = 1;
            for (int i = 0; i < this.columns.size(); ++i) {
                Column column = this.columns.get(i);
                refByColumns.put(column.column, new Reference(new ReferenceIdent(this.name, column.column), RowGranularity.DOC, column.type, ColumnPolicy.DYNAMIC, Reference.IndexType.NOT_ANALYZED, column.isNullable, rootColIdx, null));
                column.addExpression(expressions);
                if (column.column.isTopLevel()) {
                    ++rootColIdx;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DataType<?> leafType = ((DynamicColumn)column).leafType;
                dynamicColumns.put(column.column, wanted -> {
                    DynamicReference ref = new DynamicReference(new ReferenceIdent(this.name, (ColumnIdent)wanted), RowGranularity.DOC, ColumnPolicy.DYNAMIC);
                    ref.valueType(leafType);
                    return ref;
                });
            }
            return new SystemTable(this.name, refByColumns, expressions, this.primaryKeys, dynamicColumns, this.supportedOperations, this.rowGranularity, this.getRouting);
        }

        public ObjectBuilder<T, RelationBuilder<T>> startObject(String column) {
            return new ObjectBuilder<Object, RelationBuilder>(this, new ColumnIdent(column), t -> false);
        }

        public ObjectBuilder<T, RelationBuilder<T>> startObject(String column, Predicate<T> objectIsNull) {
            return new ObjectBuilder<T, RelationBuilder>(this, new ColumnIdent(column), objectIsNull);
        }

        public <U> ObjectArrayBuilder<U, T, RelationBuilder<T>> startObjectArray(String column, Function<T, ? extends Collection<U>> getItems) {
            return new ObjectArrayBuilder(this, new ColumnIdent(column), getItems);
        }

        public RelationBuilder<T> setPrimaryKeys(ColumnIdent ... primaryKeys) {
            this.primaryKeys = Arrays.asList(primaryKeys);
            return this;
        }
    }

    static class ObjectExpression<T>
    implements Function<T, Map<String, Object>> {
        private final List<Column<T, ?>> columns;
        private final Predicate<T> objectIsNull;

        ObjectExpression(List<Column<T, ?>> columns, Predicate<T> objectIsNull) {
            this.columns = columns;
            this.objectIsNull = objectIsNull;
        }

        @Override
        public Map<String, Object> apply(T t) {
            if (this.objectIsNull.test(t)) {
                return null;
            }
            HashMap<String, Object> values = new HashMap<String, Object>(this.columns.size());
            for (int i = 0; i < this.columns.size(); ++i) {
                Column<T, ?> column = this.columns.get(i);
                try {
                    Object value = column.getProperty.apply(t);
                    values.put(column.column.leafName(), value);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return values;
        }
    }

    private static class Expression<T, U>
    implements NestableCollectExpression<T, U> {
        private final ColumnIdent column;
        private final Function<T, U> getProperty;
        private final HashMap<ColumnIdent, RowCollectExpressionFactory<T>> expressions;
        private T row;

        public Expression(ColumnIdent column, Function<T, U> getProperty, HashMap<ColumnIdent, RowCollectExpressionFactory<T>> expressions) {
            this.column = column;
            this.getProperty = getProperty;
            this.expressions = expressions;
        }

        @Override
        public void setNextRow(T row) {
            this.row = row;
        }

        @Override
        public U value() {
            try {
                return this.getProperty.apply(this.row);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Override
        @Nullable
        public NestableInput<?> getChild(String name) {
            RowCollectExpressionFactory<T> factory = this.expressions.get(this.column.append(name));
            return factory == null ? null : factory.create();
        }
    }

    public static class ObjectArrayBuilder<ItemType, ParentItemType, P extends Builder<ParentItemType>>
    extends Builder<ItemType> {
        private final P parent;
        private final ArrayList<Column<ItemType, ?>> columns = new ArrayList();
        private final ColumnIdent baseColumn;
        private final Function<ParentItemType, ? extends Collection<ItemType>> getItems;

        public ObjectArrayBuilder(P parent, ColumnIdent baseColumn, Function<ParentItemType, ? extends Collection<ItemType>> getItems) {
            this.parent = parent;
            this.baseColumn = baseColumn;
            this.getItems = getItems;
        }

        public P endObjectArray() {
            ObjectType.Builder typeBuilder = ObjectType.builder();
            ArrayList directChildren = new ArrayList();
            for (Column<ItemType, ?> column : this.columns) {
                if (column.column.path().size() != this.baseColumn.path().size() + 1) continue;
                directChildren.add(column);
            }
            for (Column<Object, Object> column : directChildren) {
                typeBuilder.setInnerType(column.column.leafName(), column.type);
            }
            ObjectType objectType = typeBuilder.build();
            ((Builder)this.parent).add(new Column<ParentItemType, List<Map<String, Object>>>(this.baseColumn, new ArrayType<Map<String, Object>>(objectType), this.getLeafColumnValues(directChildren)));
            for (Column<ItemType, ?> column : this.columns) {
                this.addColumnToParent(column);
            }
            return this.parent;
        }

        public Function<ParentItemType, List<Map<String, Object>>> getLeafColumnValues(ArrayList<Column<ItemType, ?>> directChildren) {
            return xs -> {
                Collection<ItemType> items = this.getItems.apply(xs);
                ArrayList result = new ArrayList(items.size());
                for (ItemType item : items) {
                    HashMap map = new HashMap(directChildren.size());
                    for (int i = 0; i < directChildren.size(); ++i) {
                        Column column = (Column)directChildren.get(i);
                        try {
                            Object value = column.getProperty.apply(item);
                            map.put(column.column.leafName(), value);
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    result.add(map);
                }
                return result;
            };
        }

        private <U> void addColumnToParent(Column<ItemType, U> column) {
            ((Builder)this.parent).add(new Column<Object, List>(column.column, new ArrayType(column.type), xs -> {
                Collection<ItemType> items = this.getItems.apply(xs);
                ArrayList result = new ArrayList(items.size());
                for (ItemType item : items) {
                    result.add(column.getProperty.apply(item));
                }
                return result;
            }));
        }

        public <U> ObjectArrayBuilder<ItemType, ParentItemType, P> add(String column, DataType<U> type, Function<ItemType, U> getProperty) {
            return this.add((Column)new Column<ItemType, U>(this.baseColumn.append(column), type, getProperty));
        }

        protected <U> ObjectArrayBuilder<ItemType, ParentItemType, P> add(Column<ItemType, U> column) {
            this.columns.add(column);
            return this;
        }
    }

    public static class ObjectBuilder<T, P extends Builder<T>>
    extends Builder<T> {
        private final P parent;
        private final ColumnIdent baseColumn;
        private final ArrayList<Column<T, ?>> columns = new ArrayList();
        private final Predicate<T> objectIsNull;

        private ObjectBuilder(P parent, ColumnIdent baseColumn, Predicate<T> objectIsNull) {
            this.parent = parent;
            this.baseColumn = baseColumn;
            this.objectIsNull = objectIsNull;
        }

        public <U> ObjectBuilder<T, P> add(String column, DataType<U> type, Function<T, U> getProperty) {
            return this.add((Column)new Column<T, U>(this.baseColumn.append(column), type, getProperty));
        }

        public ObjectBuilder<T, P> addDynamicObject(String column, DataType<?> leafType, Function<T, Map<String, Object>> getObject) {
            return this.add(new DynamicColumn<T>(this.baseColumn.append(column), leafType, getObject));
        }

        protected <U> ObjectBuilder<T, P> add(Column<T, U> column) {
            this.columns.add(column);
            return this;
        }

        public <U> ObjectArrayBuilder<U, T, ObjectBuilder<T, P>> startObjectArray(String column, Function<T, ? extends Collection<U>> getItems) {
            return new ObjectArrayBuilder(this, this.baseColumn.append(column), getItems);
        }

        public ObjectBuilder<T, ObjectBuilder<T, P>> startObject(String column) {
            return new ObjectBuilder<T, ObjectBuilder>(this, this.baseColumn.append(column), this.objectIsNull);
        }

        public P endObject() {
            ObjectType.Builder typeBuilder = ObjectType.builder();
            ArrayList directChildren = new ArrayList();
            for (Column<T, ?> column : this.columns) {
                if (column.column.path().size() != this.baseColumn.path().size() + 1) continue;
                directChildren.add(column);
            }
            for (Column<T, Object> column : directChildren) {
                typeBuilder.setInnerType(column.column.leafName(), column.type);
            }
            ObjectType objectType = typeBuilder.build();
            ((Builder)this.parent).add(new Column(this.baseColumn, objectType, new ObjectExpression(directChildren, this.objectIsNull)));
            for (Column<T, ?> column : this.columns) {
                this.addColumnToParent(column);
            }
            return this.parent;
        }

        private <U> void addColumnToParent(Column<T, U> column) {
            ((Builder)this.parent).add(new Column(column.column, column.type, column.getProperty));
        }
    }

    public static abstract class Builder<T> {
        public abstract <U> Builder<T> add(String var1, DataType<U> var2, Function<T, U> var3);

        protected abstract <U> Builder<T> add(Column<T, U> var1);
    }

    static class DynamicColumn<T>
    extends Column<T, Map<String, Object>> {
        private final DataType<?> leafType;

        public DynamicColumn(ColumnIdent column, DataType<?> leafType, Function<T, Map<String, Object>> getObject) {
            super(column, DataTypes.UNTYPED_OBJECT, getObject);
            this.leafType = leafType;
        }

        @Override
        public void addExpression(HashMap<ColumnIdent, RowCollectExpressionFactory<T>> expressions) {
            expressions.put(this.column, () -> new MapLookupByPathExpression(this.getProperty, List.of(), this.leafType::implicitCast));
        }
    }

    static class Column<T, U> {
        protected final ColumnIdent column;
        protected final DataType<U> type;
        protected final Function<T, U> getProperty;
        protected final boolean isNullable;

        public Column(ColumnIdent column, DataType<U> type, Function<T, U> getProperty) {
            this(column, type, getProperty, true);
        }

        public Column(ColumnIdent column, DataType<U> type, Function<T, U> getProperty, boolean isNullable) {
            this.column = column;
            this.type = type;
            this.getProperty = getProperty;
            this.isNullable = isNullable;
        }

        public String toString() {
            return "(" + this.column.sqlFqn() + ", " + this.type.getName() + ")";
        }

        public void addExpression(HashMap<ColumnIdent, RowCollectExpressionFactory<T>> expressions) {
            expressions.put(this.column, () -> new Expression<T, U>(this.column, this.getProperty, expressions));
        }
    }
}

