/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.concurrent.atomic.AtomicReference;

public final class SystemClock {
    private static final AtomicReference<Clock> CURRENT_CLOCK = new AtomicReference<Clock>(Clock.systemUTC());

    public static void setClock(Clock newClock) {
        CURRENT_CLOCK.set(newClock);
    }

    public static void setCurrentMillisFixedUTC(long millis) {
        SystemClock.setClock(Clock.fixed(Instant.ofEpochMilli(millis), ZoneOffset.UTC));
    }

    public static void setCurrentMillisSystemUTC() {
        SystemClock.setClock(Clock.systemUTC());
    }

    public static Instant currentInstant() {
        return CURRENT_CLOCK.get().instant();
    }
}

