/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.analyze.user.Privilege;
import io.crate.auth.user.User;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Tuple;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocSchemaInfoFactory;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewMetadata;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.sql.tree.QualifiedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.util.set.Sets;

@Singleton
public class Schemas
extends AbstractLifecycleComponent
implements Iterable<SchemaInfo>,
ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(Schemas.class);
    public static final Collection<String> READ_ONLY_SCHEMAS = Set.of("sys", "information_schema", "pg_catalog");
    private static final Pattern SCHEMA_PATTERN = Pattern.compile("^([^.]+)\\.(.+)");
    public static final String DOC_SCHEMA_NAME = "doc";
    private final ClusterService clusterService;
    private final DocSchemaInfoFactory docSchemaInfoFactory;
    private final Map<String, SchemaInfo> schemas = new ConcurrentHashMap<String, SchemaInfo>();
    private final Map<String, SchemaInfo> builtInSchemas;

    @Inject
    public Schemas(Map<String, SchemaInfo> builtInSchemas, ClusterService clusterService, DocSchemaInfoFactory docSchemaInfoFactory) {
        this.clusterService = clusterService;
        this.docSchemaInfoFactory = docSchemaInfoFactory;
        this.schemas.putAll(builtInSchemas);
        this.builtInSchemas = builtInSchemas;
    }

    public TableInfo resolveTableInfo(QualifiedName ident, Operation operation, User user, SearchPath searchPath) {
        String identSchema = Schemas.schemaName(ident);
        String tableName = Schemas.relationName(ident);
        TableInfo tableInfo = null;
        if (identSchema == null) {
            String pathSchema;
            SchemaInfo schemaInfo;
            Iterator<String> iterator = searchPath.iterator();
            while (iterator.hasNext() && ((schemaInfo = this.schemas.get(pathSchema = iterator.next())) == null || (tableInfo = schemaInfo.getTableInfo(tableName)) == null)) {
            }
            if (tableInfo == null) {
                SchemaInfo currentSchema = this.schemas.get(searchPath.currentSchema());
                if (currentSchema == null) {
                    throw new RelationUnknown(tableName);
                }
                throw RelationUnknown.of(tableName, Schemas.getSimilarTables(user, tableName, currentSchema.getTables()));
            }
        } else {
            SchemaInfo schemaInfo = this.schemas.get(identSchema);
            if (schemaInfo == null) {
                throw SchemaUnknownException.of(identSchema, this.getSimilarSchemas(user, identSchema));
            }
            tableInfo = schemaInfo.getTableInfo(tableName);
            if (tableInfo == null) {
                throw RelationUnknown.of(ident.toString(), Schemas.getSimilarTables(user, tableName, schemaInfo.getTables()));
            }
        }
        Operation.blockedRaiseException(tableInfo, operation);
        return tableInfo;
    }

    private static List<String> getSimilarTables(User user, String tableName, Iterable<TableInfo> tables) {
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (TableInfo table : tables) {
            if (!user.hasAnyPrivilege(Privilege.Clazz.TABLE, table.ident().fqn())) continue;
            String candidate = table.ident().name();
            float score = levenshteinDistance.getDistance(tableName.toLowerCase(Locale.ENGLISH), candidate.toLowerCase(Locale.ENGLISH));
            if (!(score > 0.7f)) continue;
            candidates.add(new Candidate(score, candidate));
        }
        candidates.sort(Comparator.comparing(x -> x.score).reversed());
        return candidates.stream().limit(5L).map(x -> x.name).collect(Collectors.toList());
    }

    private List<String> getSimilarSchemas(User user, String schema) {
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (String availableSchema : this.schemas.keySet()) {
            float score;
            if (!user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, availableSchema) || !((score = levenshteinDistance.getDistance(schema.toLowerCase(Locale.ENGLISH), availableSchema.toLowerCase(Locale.ENGLISH))) > 0.7f)) continue;
            candidates.add(new Candidate(score, availableSchema));
        }
        candidates.sort(Comparator.comparing(x -> x.score).reversed());
        return candidates.stream().limit(5L).map(x -> x.name).collect(Collectors.toList());
    }

    public RelationName resolveRelation(QualifiedName ident, SearchPath searchPath) {
        String identSchema = Schemas.schemaName(ident);
        String relation = Schemas.relationName(ident);
        ViewsMetadata views = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        if (identSchema == null) {
            for (String pathSchema : searchPath) {
                RelationName tableOrViewRelation = this.getTableOrViewRelation(pathSchema, relation, views);
                if (tableOrViewRelation == null) continue;
                return tableOrViewRelation;
            }
        } else {
            RelationName tableOrViewRelation = this.getTableOrViewRelation(identSchema, relation, views);
            if (tableOrViewRelation != null) {
                return tableOrViewRelation;
            }
        }
        throw new RelationUnknown(ident.toString());
    }

    @Nullable
    private RelationName getTableOrViewRelation(String pathSchema, String relation, ViewsMetadata views) {
        SchemaInfo schemaInfo = this.schemas.get(pathSchema);
        if (schemaInfo != null) {
            RelationName viewRelation;
            TableInfo tableInfo = schemaInfo.getTableInfo(relation);
            if (tableInfo != null) {
                return new RelationName(pathSchema, relation);
            }
            if (views != null && views.contains(viewRelation = new RelationName(pathSchema, relation))) {
                return viewRelation;
            }
        }
        return null;
    }

    @Nullable
    private static String schemaName(QualifiedName ident) {
        assert (ident.getParts().size() < 3) : "When identifying schemas or tables a qualified name should not have more the 2 parts";
        List<String> parts = ident.getParts();
        if (parts.size() == 2) {
            return parts.get(0);
        }
        return null;
    }

    private static String relationName(QualifiedName ident) {
        assert (ident.getParts().size() < 3) : "When identifying schemas or tables a qualified name should not have more the 2 parts";
        List<String> parts = ident.getParts();
        if (parts.size() == 2) {
            return parts.get(1);
        }
        return parts.get(0);
    }

    public <T extends TableInfo> T getTableInfo(RelationName ident) {
        SchemaInfo schemaInfo = this.getSchemaInfo(ident);
        TableInfo info = schemaInfo.getTableInfo(ident.name());
        if (info == null) {
            throw new RelationUnknown(ident);
        }
        return (T)info;
    }

    public <T extends TableInfo> T getTableInfo(RelationName ident, Operation operation) {
        T tableInfo = this.getTableInfo(ident);
        Operation.blockedRaiseException(tableInfo, operation);
        return tableInfo;
    }

    private SchemaInfo getSchemaInfo(RelationName ident) {
        String schemaName = ident.schema();
        SchemaInfo schemaInfo = this.schemas.get(schemaName);
        if (schemaInfo == null) {
            throw new SchemaUnknownException(schemaName);
        }
        return schemaInfo;
    }

    @Override
    @Nonnull
    public Iterator<SchemaInfo> iterator() {
        return this.schemas.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.metadataChanged()) {
            return;
        }
        Set<String> newCurrentSchemas = Schemas.getNewCurrentSchemas(event.state().metadata());
        Map<String, SchemaInfo> map = this.schemas;
        synchronized (map) {
            Set<String> nonBuiltInSchemas = Sets.difference(this.schemas.keySet(), this.builtInSchemas.keySet());
            Set<String> deleted = Sets.difference(nonBuiltInSchemas, newCurrentSchemas);
            Set<String> added = Sets.difference(newCurrentSchemas, this.schemas.keySet());
            for (String deletedSchema : deleted) {
                try {
                    this.schemas.remove(deletedSchema).close();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            for (String addedSchema : added) {
                this.schemas.put(addedSchema, this.getCustomSchemaInfo(addedSchema));
            }
            for (SchemaInfo schemaInfo : this) {
                schemaInfo.update(event);
            }
        }
    }

    @VisibleForTesting
    static Set<String> getNewCurrentSchemas(Metadata metadata) {
        ViewsMetadata viewsMetadata;
        HashSet<String> schemas = new HashSet<String>();
        schemas.add(DOC_SCHEMA_NAME);
        for (String index : metadata.getConcreteAllIndices()) {
            Schemas.addIfSchema(schemas, index);
        }
        for (ObjectCursor cursor : metadata.templates().keys()) {
            Schemas.addIfSchema(schemas, (String)cursor.value);
        }
        UserDefinedFunctionsMetadata udfMetadata = (UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions");
        if (udfMetadata != null) {
            udfMetadata.functionsMetadata().stream().map(UserDefinedFunctionMetadata::schema).forEach(schemas::add);
        }
        if ((viewsMetadata = (ViewsMetadata)metadata.custom("views")) != null) {
            StreamSupport.stream(viewsMetadata.names().spliterator(), false).map(IndexParts::new).map(IndexParts::getSchema).forEach(schemas::add);
        }
        return schemas;
    }

    private static void addIfSchema(Set<String> schemas, String indexOrTemplate) {
        Matcher matcher = SCHEMA_PATTERN.matcher(indexOrTemplate);
        if (matcher.matches()) {
            schemas.add(matcher.group(1));
        }
    }

    private SchemaInfo getCustomSchemaInfo(String name) {
        return this.docSchemaInfoFactory.create(name, this.clusterService);
    }

    public static boolean isDefaultOrCustomSchema(@Nullable String schemaName) {
        if (schemaName == null) {
            return true;
        }
        return !schemaName.equalsIgnoreCase("information_schema") && !schemaName.equalsIgnoreCase("sys") && !schemaName.equalsIgnoreCase("blob");
    }

    public boolean tableExists(RelationName relationName) {
        SchemaInfo schemaInfo = this.schemas.get(relationName.schema());
        if (schemaInfo == null) {
            return false;
        }
        schemaInfo.invalidateTableCache(relationName.name());
        TableInfo tableInfo = schemaInfo.getTableInfo(relationName.name());
        return tableInfo != null;
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
    }

    public Tuple<ViewMetadata, RelationName> resolveView(QualifiedName ident, SearchPath searchPath) {
        ViewsMetadata views = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        ViewMetadata view = null;
        RelationName viewRelationName = null;
        String identSchema = Schemas.schemaName(ident);
        String viewName = Schemas.relationName(ident);
        if (views != null) {
            if (identSchema == null) {
                String pathSchema;
                SchemaInfo schemaInfo;
                Iterator<String> iterator = searchPath.iterator();
                while (iterator.hasNext() && ((schemaInfo = this.schemas.get(pathSchema = iterator.next())) == null || (view = views.getView(viewRelationName = new RelationName(pathSchema, viewName))) == null)) {
                }
            } else {
                viewRelationName = new RelationName(identSchema, viewName);
                view = views.getView(viewRelationName);
            }
        }
        if (view == null) {
            throw new RelationUnknown(viewName);
        }
        return Tuple.tuple(view, viewRelationName);
    }

    public boolean viewExists(RelationName relationName) {
        ViewsMetadata views = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        return views != null && views.getView(relationName) != null;
    }

    static class Candidate {
        final double score;
        final String name;

        Candidate(double score, String name) {
            this.score = score;
            this.name = name;
        }
    }
}

