/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class Scalar<ReturnType, InputType>
implements FunctionImplementation {
    public static final Set<Feature> NO_FEATURES = Set.of();
    public static final Set<Feature> DETERMINISTIC_ONLY = EnumSet.of(Feature.DETERMINISTIC);
    public static final Set<Feature> DETERMINISTIC_AND_COMPARISON_REPLACEMENT = EnumSet.of(Feature.DETERMINISTIC, Feature.COMPARISON_REPLACEMENT);

    public abstract ReturnType evaluate(TransactionContext var1, NodeContext var2, Input<InputType> ... var3);

    public Scalar<ReturnType, InputType> compile(List<Symbol> arguments) {
        return this;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        try {
            return Scalar.evaluateIfLiterals(this, txnCtx, nodeCtx, symbol);
        }
        catch (Throwable t) {
            return symbol;
        }
    }

    protected static boolean anyNonLiterals(Collection<? extends Symbol> arguments) {
        for (Symbol symbol : arguments) {
            if (symbol.symbolType().isValueSymbol()) continue;
            return true;
        }
        return false;
    }

    protected static <ReturnType, InputType> Symbol evaluateIfLiterals(Scalar<ReturnType, InputType> scalar, TransactionContext txnCtx, NodeContext nodeCtx, Function function) {
        List<Symbol> arguments = function.arguments();
        for (Symbol argument : arguments) {
            if (argument instanceof Input) continue;
            return function;
        }
        Input[] inputs = new Input[arguments.size()];
        int idx = 0;
        for (Symbol arg : arguments) {
            inputs[idx] = (Input)((Object)arg);
            ++idx;
        }
        return Literal.ofUnchecked(function.valueType(), scalar.evaluate(txnCtx, nodeCtx, inputs));
    }

    public static enum Feature {
        DETERMINISTIC,
        COMPARISON_REPLACEMENT,
        LAZY_ATTRIBUTES;

    }
}

