/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.RoutineInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.settings.Settings;

public class RoutineInfos
implements Iterable<RoutineInfo> {
    private static final Logger LOGGER = LogManager.getLogger(RoutineInfos.class);
    private final UserDefinedFunctionsMetadata functionsMetadata;
    private FulltextAnalyzerResolver ftResolver;

    public RoutineInfos(FulltextAnalyzerResolver ftResolver, UserDefinedFunctionsMetadata functionsMetadata) {
        this.ftResolver = ftResolver;
        this.functionsMetadata = functionsMetadata;
    }

    private Iterator<RoutineInfo> builtInAnalyzers() {
        return this.ftResolver.getBuiltInAnalyzers().stream().map(x -> new RoutineInfo((String)x, RoutineType.ANALYZER.getName())).iterator();
    }

    private Iterator<RoutineInfo> builtInCharFilters() {
        return this.ftResolver.getBuiltInCharFilters().stream().map(x -> new RoutineInfo((String)x, RoutineType.CHAR_FILTER.getName())).iterator();
    }

    private Iterator<RoutineInfo> builtInTokenFilters() {
        return this.ftResolver.getBuiltInTokenFilters().stream().map(x -> new RoutineInfo((String)x, RoutineType.TOKEN_FILTER.getName())).iterator();
    }

    private Iterator<RoutineInfo> builtInTokenizers() {
        return this.ftResolver.getBuiltInTokenizers().stream().map(x -> new RoutineInfo((String)x, RoutineType.TOKENIZER.getName())).iterator();
    }

    private Iterator<RoutineInfo> userDefinedFunctions() {
        if (this.functionsMetadata == null) {
            return Collections.emptyIterator();
        }
        return this.functionsMetadata.functionsMetadata().stream().map(x -> new RoutineInfo(x.name(), RoutineType.FUNCTION.getName(), x.schema(), x.specificName(), x.definition(), x.language(), x.returnType().getName(), true)).iterator();
    }

    private Iterator<RoutineInfo> customIterators() {
        try {
            Iterator cAnalyzersIterator = this.ftResolver.getCustomAnalyzers().entrySet().stream().map(x -> new RoutineInfo((String)x.getKey(), RoutineType.ANALYZER.getName(), RoutineInfos.routineSettingsToDefinition((String)x.getKey(), (Settings)x.getValue(), RoutineType.ANALYZER))).iterator();
            Iterator cCharFiltersIterator = this.ftResolver.getCustomCharFilters().entrySet().stream().map(x -> new RoutineInfo((String)x.getKey(), RoutineType.CHAR_FILTER.getName(), RoutineInfos.routineSettingsToDefinition((String)x.getKey(), (Settings)x.getValue(), RoutineType.CHAR_FILTER))).iterator();
            Iterator cTokenFiltersIterator = this.ftResolver.getCustomTokenFilters().entrySet().stream().map(x -> new RoutineInfo((String)x.getKey(), RoutineType.TOKEN_FILTER.getName(), RoutineInfos.routineSettingsToDefinition((String)x.getKey(), (Settings)x.getValue(), RoutineType.TOKEN_FILTER))).iterator();
            Iterator cTokenizersIterator = this.ftResolver.getCustomTokenizers().entrySet().stream().map(x -> new RoutineInfo((String)x.getKey(), RoutineType.TOKENIZER.getName(), RoutineInfos.routineSettingsToDefinition((String)x.getKey(), (Settings)x.getValue(), RoutineType.TOKENIZER))).iterator();
            return Iterators.concat(cAnalyzersIterator, cCharFiltersIterator, cTokenFiltersIterator, cTokenizersIterator);
        }
        catch (IOException e) {
            LOGGER.error("Could not retrieve custom routines", (Throwable)e);
            return null;
        }
    }

    @Override
    public Iterator<RoutineInfo> iterator() {
        return Iterators.concat(this.builtInAnalyzers(), this.builtInCharFilters(), this.builtInTokenFilters(), this.builtInTokenizers(), this.customIterators(), this.userDefinedFunctions());
    }

    private static String routineSettingsToDefinition(String name, Settings settings, RoutineType type) {
        String prefix = "index.analysis." + type.getName().toLowerCase(Locale.ENGLISH) + "." + name + ".";
        return settings.getByPrefix(prefix).toString();
    }

    private static enum RoutineType {
        ANALYZER(FulltextAnalyzerResolver.CustomType.ANALYZER.getName().toUpperCase(Locale.ENGLISH)),
        CHAR_FILTER(FulltextAnalyzerResolver.CustomType.CHAR_FILTER.getName().toUpperCase(Locale.ENGLISH)),
        TOKEN_FILTER("TOKEN_FILTER"),
        FUNCTION("FUNCTION"),
        TOKENIZER(FulltextAnalyzerResolver.CustomType.TOKENIZER.getName().toUpperCase(Locale.ENGLISH));

        private String name;

        private RoutineType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

