/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.blob.v2.BlobIndex;
import io.crate.exceptions.InvalidRelationName;
import io.crate.exceptions.InvalidSchemaNameException;
import io.crate.metadata.IndexParts;
import io.crate.metadata.Schemas;
import io.crate.sql.Identifiers;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Table;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class RelationName
implements Writeable {
    private static final Set<String> INVALID_NAME_CHARACTERS = Set.of(".");
    @Nullable
    private final String schema;
    private final String name;

    public static RelationName of(QualifiedName name, String defaultSchema) {
        List<String> parts = name.getParts();
        if (parts.size() > 2) {
            throw new IllegalArgumentException("Table with more than 2 QualifiedName parts is not supported. Only <schema>.<tableName> works.");
        }
        if (parts.size() == 2) {
            return new RelationName(parts.get(0), parts.get(1));
        }
        return new RelationName(defaultSchema, parts.get(0));
    }

    public static RelationName fromBlobTable(Table<?> table) {
        List<String> tableNameParts = table.getName().getParts();
        if (tableNameParts.size() > 2) {
            throw new IllegalArgumentException("Invalid tableName \"" + table.getName() + "\"");
        }
        if (tableNameParts.size() == 2) {
            if (!tableNameParts.get(0).equalsIgnoreCase("blob")) {
                throw new IllegalArgumentException("The Schema \"" + tableNameParts.get(0) + "\" isn't valid in a [CREATE | ALTER] BLOB TABLE clause");
            }
            return new RelationName(tableNameParts.get(0), tableNameParts.get(1));
        }
        assert (tableNameParts.size() == 1) : "tableNameParts.size() must be 1";
        return new RelationName("blob", tableNameParts.get(0));
    }

    public static RelationName fromIndexName(String indexName) {
        IndexParts indexParts = new IndexParts(indexName);
        return indexParts.toRelationName();
    }

    public static String fqnFromIndexName(String indexName) {
        return new IndexParts(indexName).toFullyQualifiedName();
    }

    public RelationName(StreamInput in) throws IOException {
        this.schema = in.getVersion().before(Version.V_4_2_0) ? in.readString() : in.readOptionalString();
        this.name = in.readString();
    }

    public RelationName(@Nullable String schema, String name) {
        assert (name != null) : "table name must not be null";
        this.schema = schema;
        this.name = name;
    }

    @Nullable
    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public String fqn() {
        if (this.schema == null) {
            return this.name;
        }
        return this.schema + "." + this.name;
    }

    public String sqlFqn() {
        if (this.schema == null) {
            return Identifiers.quoteIfNeeded(this.name);
        }
        return Identifiers.quoteIfNeeded(this.schema) + "." + Identifiers.quoteIfNeeded(this.name);
    }

    public QualifiedName toQualifiedName() {
        if (this.schema == null) {
            return new QualifiedName(this.name);
        }
        return new QualifiedName(List.of(this.schema, this.name));
    }

    public String indexNameOrAlias() {
        if (this.schema == null) {
            throw new IllegalStateException("indexNameOrAlias can only be generated from a RelationName that is fully qualified.");
        }
        if (this.schema.equalsIgnoreCase("doc")) {
            return this.name;
        }
        if (this.schema.equalsIgnoreCase("blob")) {
            return BlobIndex.fullIndexName(this.name);
        }
        return this.fqn();
    }

    public void ensureValidForRelationCreation() throws InvalidSchemaNameException, InvalidRelationName {
        if (!RelationName.isValidRelationOrSchemaName(this.schema)) {
            throw new InvalidSchemaNameException(this.schema);
        }
        if (!RelationName.isValidRelationOrSchemaName(this.name)) {
            throw new InvalidRelationName(this);
        }
        if (Schemas.READ_ONLY_SCHEMAS.contains(this.schema)) {
            throw new IllegalArgumentException("Cannot create relation in read-only schema: " + this.schema);
        }
    }

    private static boolean isValidRelationOrSchemaName(String name) {
        for (String illegalCharacter : INVALID_NAME_CHARACTERS) {
            if (!name.contains(illegalCharacter) && name.length() != 0) continue;
            return false;
        }
        return !name.startsWith("_");
    }

    public String toString() {
        return this.fqn();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_4_2_0)) {
            out.writeString(this.schema == null ? "doc" : this.schema);
        } else {
            out.writeOptionalString(this.schema);
        }
        out.writeString(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationName that = (RelationName)o;
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.schema != null ? this.schema.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

