/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ReferenceIdent {
    private final RelationName relationName;
    private final ColumnIdent columnIdent;

    public ReferenceIdent(StreamInput in) throws IOException {
        this.columnIdent = new ColumnIdent(in);
        this.relationName = new RelationName(in);
    }

    public ReferenceIdent(RelationName relationName, ColumnIdent columnIdent) {
        this.relationName = relationName;
        this.columnIdent = columnIdent;
    }

    public ReferenceIdent(RelationName relationName, String column) {
        this(relationName, new ColumnIdent(column));
    }

    public ReferenceIdent(RelationName relationName, String column, @Nullable List<String> path) {
        this(relationName, new ColumnIdent(column, path));
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    public ColumnIdent columnIdent() {
        return this.columnIdent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceIdent that = (ReferenceIdent)o;
        return Objects.equals(this.relationName, that.relationName) && Objects.equals(this.columnIdent, that.columnIdent);
    }

    public int hashCode() {
        return Objects.hash(this.relationName, this.columnIdent);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "<RefIdent: %s->%s>", this.relationName, this.columnIdent);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.columnIdent.writeTo(out);
        this.relationName.writeTo(out);
    }
}

