/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Reference
extends Symbol {
    protected DataType<?> type;
    @Nullable
    private final Integer position;
    private final ReferenceIdent ident;
    private final ColumnPolicy columnPolicy;
    private final RowGranularity granularity;
    private final IndexType indexType;
    private final boolean nullable;
    private final boolean columnStoreDisabled;
    @Nullable
    private final Symbol defaultExpression;

    public Reference(StreamInput in) throws IOException {
        this.ident = new ReferenceIdent(in);
        this.position = in.readOptionalVInt();
        this.type = DataTypes.fromStream(in);
        this.granularity = RowGranularity.fromStream(in);
        this.columnPolicy = ColumnPolicy.values()[in.readVInt()];
        this.indexType = IndexType.values()[in.readVInt()];
        this.nullable = in.readBoolean();
        this.columnStoreDisabled = in.readBoolean();
        boolean hasDefaultExpression = in.readBoolean();
        this.defaultExpression = hasDefaultExpression ? Symbols.fromStream(in) : null;
    }

    public Reference(ReferenceIdent ident, RowGranularity granularity, DataType<?> type, @Nullable Integer position, @Nullable Symbol defaultExpression) {
        this(ident, granularity, type, ColumnPolicy.DYNAMIC, IndexType.NOT_ANALYZED, true, position, defaultExpression);
    }

    public Reference(ReferenceIdent ident, RowGranularity granularity, DataType<?> type, ColumnPolicy columnPolicy, IndexType indexType, boolean nullable, @Nullable Integer position, @Nullable Symbol defaultExpression) {
        this(ident, granularity, type, columnPolicy, indexType, nullable, false, position, defaultExpression);
    }

    public Reference(ReferenceIdent ident, RowGranularity granularity, DataType<?> type, ColumnPolicy columnPolicy, IndexType indexType, boolean nullable, boolean columnStoreDisabled, @Nullable Integer position, @Nullable Symbol defaultExpression) {
        this.position = position;
        this.ident = ident;
        this.type = type;
        this.granularity = granularity;
        this.columnPolicy = columnPolicy;
        this.indexType = indexType;
        this.nullable = nullable;
        this.columnStoreDisabled = columnStoreDisabled;
        this.defaultExpression = defaultExpression;
    }

    public Reference getRelocated(ReferenceIdent newIdent) {
        return new Reference(newIdent, this.granularity, this.type, this.columnPolicy, this.indexType, this.nullable, this.columnStoreDisabled, this.position, this.defaultExpression);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.REFERENCE;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitReference(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.type;
    }

    @Override
    public String toString(Style style) {
        if (style == Style.QUALIFIED) {
            return this.ident.tableIdent().sqlFqn() + "." + this.column().quotedOutputName();
        }
        return this.column().quotedOutputName();
    }

    public ReferenceIdent ident() {
        return this.ident;
    }

    public ColumnIdent column() {
        return this.ident.columnIdent();
    }

    public RowGranularity granularity() {
        return this.granularity;
    }

    public ColumnPolicy columnPolicy() {
        return this.columnPolicy;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isColumnStoreDisabled() {
        return this.columnStoreDisabled;
    }

    @Nullable
    public Integer position() {
        return this.position;
    }

    @Nullable
    public Symbol defaultExpression() {
        return this.defaultExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        if (this.nullable != reference.nullable) {
            return false;
        }
        if (this.columnStoreDisabled != reference.columnStoreDisabled) {
            return false;
        }
        if (!this.type.equals(reference.type)) {
            return false;
        }
        if (!Objects.equals(this.position, reference.position)) {
            return false;
        }
        if (!this.ident.equals(reference.ident)) {
            return false;
        }
        if (this.columnPolicy != reference.columnPolicy) {
            return false;
        }
        if (this.granularity != reference.granularity) {
            return false;
        }
        if (this.indexType != reference.indexType) {
            return false;
        }
        return Objects.equals(this.defaultExpression, reference.defaultExpression);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        result = 31 * result + this.ident.hashCode();
        result = 31 * result + this.columnPolicy.hashCode();
        result = 31 * result + this.granularity.hashCode();
        result = 31 * result + this.indexType.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + (this.columnStoreDisabled ? 1 : 0);
        result = 31 * result + (this.defaultExpression != null ? this.defaultExpression.hashCode() : 0);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.ident.writeTo(out);
        out.writeOptionalVInt(this.position);
        DataTypes.toStream(this.type, out);
        RowGranularity.toStream(this.granularity, out);
        out.writeVInt(this.columnPolicy.ordinal());
        out.writeVInt(this.indexType.ordinal());
        out.writeBoolean(this.nullable);
        out.writeBoolean(this.columnStoreDisabled);
        boolean hasDefaultExpression = this.defaultExpression != null;
        out.writeBoolean(hasDefaultExpression);
        if (hasDefaultExpression) {
            Symbols.toStream(this.defaultExpression, out);
        }
    }

    public static void toStream(Reference reference, StreamOutput out) throws IOException {
        out.writeVInt(reference.symbolType().ordinal());
        reference.writeTo(out);
    }

    public static <R extends Reference> R fromStream(StreamInput in) throws IOException {
        return (R)((Reference)SymbolType.VALUES.get(in.readVInt()).newInstance(in));
    }

    public static enum IndexType {
        ANALYZED,
        NOT_ANALYZED,
        NO;

    }
}

