/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.partitioned.PartitionExpression;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionReferenceResolver
implements ReferenceResolver<PartitionExpression> {
    private final Map<ReferenceIdent, PartitionExpression> expressionMap;
    private final List<PartitionExpression> partitionExpressions;

    public PartitionReferenceResolver(List<PartitionExpression> partitionExpressions) {
        this.partitionExpressions = partitionExpressions;
        this.expressionMap = new HashMap<ReferenceIdent, PartitionExpression>(partitionExpressions.size(), 1.0f);
        for (PartitionExpression partitionExpression : partitionExpressions) {
            this.expressionMap.put(partitionExpression.reference().ident(), partitionExpression);
        }
    }

    @Override
    public PartitionExpression getImplementation(Reference ref) {
        PartitionExpression expression = this.expressionMap.get(ref.ident());
        assert (expression != null) : "granularity < PARTITION should have been resolved already";
        return expression;
    }

    public List<PartitionExpression> expressions() {
        return this.partitionExpressions;
    }
}

