/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base32;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;

public class PartitionName {
    private static final Base32 BASE32 = new Base32(true);
    private final RelationName relationName;
    @Nullable
    private List<String> values;
    @Nullable
    private String indexName;
    @Nullable
    private String ident;

    public PartitionName(RelationName relationName, @Nonnull List<String> values) {
        this.relationName = relationName;
        this.values = Objects.requireNonNull(values);
    }

    public PartitionName(RelationName relationName, @Nonnull String partitionIdent) {
        this.relationName = relationName;
        this.ident = Objects.requireNonNull(partitionIdent);
    }

    public static String templateName(String indexName) {
        RelationName relationName = PartitionName.fromIndexOrTemplate((String)indexName).relationName;
        return PartitionName.templateName(relationName.schema(), relationName.name());
    }

    @Nullable
    public static List<String> decodeIdent(@Nullable String ident) {
        ArrayList<String> arrayList;
        block10: {
            if (ident == null) {
                return List.of();
            }
            byte[] inputBytes = BASE32.decode(ident.toUpperCase(Locale.ROOT));
            StreamInput in = StreamInput.wrap(inputBytes);
            try {
                int size = in.readVInt();
                ArrayList<String> values = new ArrayList<String>(size);
                for (int i = 0; i < size; ++i) {
                    values.add(PartitionName.readValueFrom(in));
                }
                arrayList = values;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid partition ident: %s", ident), e);
                }
            }
            in.close();
        }
        return arrayList;
    }

    private static String readValueFrom(StreamInput in) throws IOException {
        int length = in.readVInt() - 1;
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        in.readBytes(bytes, 0, length);
        char[] chars = new char[length];
        int len = UnicodeUtil.UTF8toUTF16((byte[])bytes, (int)0, (int)length, (char[])chars);
        return new String(chars, 0, len);
    }

    private static void writeValueTo(BytesStreamOutput out, @Nullable String value) throws IOException {
        if (value == null) {
            out.writeVInt(0);
        } else {
            byte[] v = value.getBytes(StandardCharsets.UTF_8);
            out.writeVInt(v.length + 1);
            out.writeBytes(v, 0, v.length);
        }
    }

    @Nullable
    public static String encodeIdent(Collection<? extends String> values) {
        if (values.size() == 0) {
            return null;
        }
        BytesStreamOutput streamOutput = new BytesStreamOutput(PartitionName.estimateSize(values));
        try {
            streamOutput.writeVInt(values.size());
            for (String string : values) {
                PartitionName.writeValueTo(streamOutput, string);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = BytesReference.toBytes(streamOutput.bytes());
        String string = BASE32.encodeAsString(bytes).toLowerCase(Locale.ROOT);
        int idx = string.indexOf(61);
        if (idx > -1) {
            return string.substring(0, idx);
        }
        return string;
    }

    private static int estimateSize(Iterable<? extends String> values) {
        int expectedEncodedSize = 0;
        for (String string : values) {
            expectedEncodedSize += 5 + (string != null ? string.length() : 0);
        }
        return expectedEncodedSize;
    }

    public String asIndexName() {
        if (this.indexName == null) {
            this.indexName = IndexParts.toIndexName(this);
        }
        return this.indexName;
    }

    @Nullable
    public String ident() {
        if (this.ident == null) {
            this.ident = PartitionName.encodeIdent(this.values);
        }
        return this.ident;
    }

    public List<String> values() {
        if (this.values == null) {
            if (this.ident == null) {
                return List.of();
            }
            this.values = PartitionName.decodeIdent(this.ident);
        }
        return this.values;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public String toString() {
        return this.asIndexName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionName that = (PartitionName)o;
        return this.asIndexName().equals(that.asIndexName());
    }

    public int hashCode() {
        return this.asIndexName().hashCode();
    }

    public static PartitionName fromIndexOrTemplate(String indexOrTemplate) {
        assert (indexOrTemplate != null) : "indexOrTemplate must not be null";
        IndexParts indexParts = new IndexParts(indexOrTemplate);
        if (!indexParts.isPartitioned()) {
            throw new IllegalArgumentException("Invalid index name: " + indexOrTemplate);
        }
        return new PartitionName(new RelationName(indexParts.getSchema(), indexParts.getTable()), indexParts.getPartitionIdent());
    }

    public static String templateName(String schemaName, String tableName) {
        return IndexParts.toIndexName(schemaName, tableName, "");
    }

    public static String templatePrefix(String schemaName, String tableName) {
        return PartitionName.templateName(schemaName, tableName) + "*";
    }
}

