/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.analyze.NumberOfReplicas;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionInfo;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocIndexMetadata;
import io.crate.types.DataType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;

public class PartitionInfos
implements Iterable<PartitionInfo> {
    private final ClusterService clusterService;
    private static final Logger LOGGER = LogManager.getLogger(PartitionInfos.class);

    public PartitionInfos(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public Iterator<PartitionInfo> iterator() {
        return StreamSupport.stream(this.clusterService.state().metadata().indices().spliterator(), false).filter(entry -> IndexParts.isPartitioned((String)entry.key)).map(PartitionInfos::createPartitionInfo).filter(Objects::nonNull).iterator();
    }

    private static PartitionInfo createPartitionInfo(ObjectObjectCursor<String, IndexMetadata> indexMetadataEntry) {
        String indexName = (String)indexMetadataEntry.key;
        IndexMetadata indexMetadata = (IndexMetadata)indexMetadataEntry.value;
        PartitionName partitionName = PartitionName.fromIndexOrTemplate(indexName);
        try {
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            if (mappingMetadata == null) {
                LOGGER.trace("Cannot resolve mapping definition of index {}", (Object)indexName);
                return null;
            }
            Map<String, Object> mappingMap = mappingMetadata.sourceAsMap();
            Map<String, Object> valuesMap = PartitionInfos.buildValuesMap(partitionName, mappingMap);
            Settings settings = indexMetadata.getSettings();
            String numberOfReplicas = NumberOfReplicas.fromSettings(settings);
            return new PartitionInfo(partitionName, indexMetadata.getNumberOfShards(), numberOfReplicas, IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings), settings.getAsVersion("index.version.upgraded", null), DocIndexMetadata.isClosed(indexMetadata, mappingMap, false), valuesMap, indexMetadata.getSettings());
        }
        catch (Exception e) {
            LOGGER.trace("error extracting partition infos from index " + indexMetadata, (Throwable)e);
            return null;
        }
    }

    private static Map<String, Object> buildValuesMap(PartitionName partitionName, Map<String, Object> mappingMetadata) throws Exception {
        Map meta = (Map)mappingMetadata.get("_meta");
        if (meta == null) {
            return Map.of();
        }
        Object partitionedBy = meta.get("partitioned_by");
        if (!(partitionedBy instanceof List)) {
            return Map.of();
        }
        List partitionedByColumns = (List)partitionedBy;
        assert (partitionedByColumns.size() == partitionName.values().size()) : "partitionedByColumns size must match partitionName values size";
        HashMap<String, Object> valuesByColumn = new HashMap<String, Object>();
        for (int i = 0; i < partitionedByColumns.size(); ++i) {
            List columnAndType = (List)partitionedByColumns.get(i);
            assert (columnAndType.size() == 2) : "_meta['partitioned_by'] mapping must contain (columnName, datatype) pairs";
            String dottedColumnName = (String)columnAndType.get(0);
            String sqlFqn = ColumnIdent.fromPath(dottedColumnName).sqlFqn();
            String typeName = (String)columnAndType.get(1);
            DataType<?> type = DocIndexMetadata.getColumnDataType(Map.of("type", typeName));
            Object value = type.implicitCast(partitionName.values().get(i));
            valuesByColumn.put(sqlFqn, value);
        }
        return valuesByColumn;
    }
}

