/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.PartitionName;
import io.crate.metadata.table.StoredTable;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;

public class PartitionInfo
implements StoredTable {
    private final PartitionName name;
    private final int numberOfShards;
    private final String numberOfReplicas;
    private final Version versionCreated;
    private final Version versionUpgraded;
    private final boolean closed;
    private final Map<String, Object> values;
    private final Settings tableParameters;

    public PartitionInfo(PartitionName name, int numberOfShards, String numberOfReplicas, @Nullable Version versionCreated, @Nullable Version versionUpgraded, boolean closed, Map<String, Object> values, Settings tableParameters) {
        this.name = name;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.versionCreated = versionCreated;
        this.versionUpgraded = versionUpgraded;
        this.closed = closed;
        this.values = values;
        this.tableParameters = tableParameters;
    }

    public PartitionName name() {
        return this.name;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public String numberOfReplicas() {
        return this.numberOfReplicas;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Map<String, Object> values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.numberOfReplicas != that.numberOfReplicas) {
            return false;
        }
        return this.numberOfShards == that.numberOfShards;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.numberOfShards;
        result = 31 * result + this.numberOfReplicas.hashCode();
        return result;
    }

    public String toString() {
        return "PartitionInfo{name=" + this.name + ", numberOfShards=" + this.numberOfShards + ", numberOfReplicas=" + this.numberOfReplicas + ", versionCreated=" + this.versionCreated + ", versionUpgraded=" + this.versionUpgraded + ", closed=" + this.closed + "}";
    }

    public Settings tableParameters() {
        return this.tableParameters;
    }

    @Override
    @Nullable
    public Version versionCreated() {
        return this.versionCreated;
    }

    @Override
    @Nullable
    public Version versionUpgraded() {
        return this.versionUpgraded;
    }
}

