/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexReference
extends Reference {
    @Nullable
    private final String analyzer;
    private final List<Reference> columns;

    public IndexReference(StreamInput in) throws IOException {
        super(in);
        this.analyzer = in.readOptionalString();
        int size = in.readVInt();
        this.columns = new ArrayList<Reference>(size);
        for (int i = 0; i < size; ++i) {
            this.columns.add((Reference)Reference.fromStream(in));
        }
    }

    public IndexReference(Integer position, ReferenceIdent ident, Reference.IndexType indexType, List<Reference> columns, @Nullable String analyzer) {
        super(ident, RowGranularity.DOC, DataTypes.STRING, ColumnPolicy.DYNAMIC, indexType, false, true, position, null);
        this.columns = columns;
        this.analyzer = analyzer;
    }

    public List<Reference> columns() {
        return this.columns;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.INDEX_REFERENCE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexReference that = (IndexReference)o;
        return Objects.equals(this.analyzer, that.analyzer) && Objects.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.analyzer, this.columns);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeVInt(this.columns.size());
        for (Reference reference : this.columns) {
            Reference.toStream(reference, out);
        }
    }

    public static class Builder {
        private final ReferenceIdent ident;
        private Reference.IndexType indexType = Reference.IndexType.ANALYZED;
        private List<Reference> columns = new ArrayList<Reference>();
        private String analyzer = null;
        private Integer position = null;

        public Builder(ReferenceIdent ident) {
            Objects.requireNonNull(ident, "ident is null");
            this.ident = ident;
        }

        public Builder indexType(Reference.IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder addColumn(Reference info) {
            this.columns.add(info);
            return this;
        }

        public Builder analyzer(String name) {
            this.analyzer = name;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public IndexReference build() {
            return new IndexReference(this.position, this.ident, this.indexType, this.columns, this.analyzer);
        }
    }
}

