/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.blob.v2.BlobIndex;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.List;
import javax.annotation.Nullable;

public class IndexParts {
    private static final String PARTITIONED_KEY_WORD = "partitioned";
    @VisibleForTesting
    static final String PARTITIONED_TABLE_PART = ".partitioned.";
    public static final List<String> DANGLING_INDICES_PREFIX_PATTERNS = List.of(".resized.*");
    private final String schema;
    private final String table;
    private final String partitionIdent;

    public IndexParts(String indexName) {
        this(indexName, "doc");
    }

    public IndexParts(String indexName, String defaultSchema) {
        if (BlobIndex.isBlobIndex(indexName)) {
            this.schema = "blob";
            this.table = BlobIndex.stripPrefix(indexName);
            this.partitionIdent = null;
        } else {
            List<String> parts = List.of(indexName.split("\\.", 6));
            switch (parts.size()) {
                case 1: {
                    this.schema = defaultSchema;
                    this.table = indexName;
                    this.partitionIdent = null;
                    break;
                }
                case 2: {
                    this.schema = parts.get(0);
                    this.table = parts.get(1);
                    this.partitionIdent = null;
                    break;
                }
                case 4: {
                    IndexParts.assertEmpty(parts.get(0));
                    this.schema = defaultSchema;
                    IndexParts.assertPartitionPrefix(parts.get(1));
                    this.table = parts.get(2);
                    this.partitionIdent = parts.get(3);
                    break;
                }
                case 5: {
                    this.schema = parts.get(0);
                    IndexParts.assertEmpty(parts.get(1));
                    IndexParts.assertPartitionPrefix(parts.get(2));
                    this.table = parts.get(3);
                    this.partitionIdent = parts.get(4);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid index name: " + indexName);
                }
            }
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getPartitionIdent() {
        return this.isPartitioned() ? this.partitionIdent : "";
    }

    public boolean isPartitioned() {
        return this.partitionIdent != null;
    }

    public RelationName toRelationName() {
        return new RelationName(this.schema, this.table);
    }

    public String toFullyQualifiedName() {
        return this.schema + "." + this.table;
    }

    public boolean matchesSchema(String schema) {
        return this.schema.equals(schema);
    }

    public static String toIndexName(RelationName relationName, String partitionIdent) {
        return IndexParts.toIndexName(relationName.schema(), relationName.name(), partitionIdent);
    }

    public static String toIndexName(PartitionName partitionName) {
        RelationName relationName = partitionName.relationName();
        return IndexParts.toIndexName(relationName.schema(), relationName.name(), partitionName.ident());
    }

    public static String toIndexName(String schema, String table, @Nullable String partitionIdent) {
        boolean isPartitioned;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = isPartitioned = partitionIdent != null;
        if (!schema.equalsIgnoreCase("doc")) {
            stringBuilder.append(schema).append(".");
        }
        if (isPartitioned) {
            stringBuilder.append(PARTITIONED_TABLE_PART);
        }
        stringBuilder.append(table);
        if (isPartitioned) {
            stringBuilder.append(".").append(partitionIdent);
        }
        return stringBuilder.toString();
    }

    public static boolean isPartitioned(String templateOrIndex) {
        int idx1 = templateOrIndex.indexOf(46);
        if (idx1 == -1) {
            return false;
        }
        int idx2 = templateOrIndex.indexOf(PARTITIONED_TABLE_PART, idx1);
        if (idx2 == -1) {
            return false;
        }
        int diff = idx2 - idx1;
        return (diff == 0 && idx1 == 0 || diff == 1) && idx2 + PARTITIONED_TABLE_PART.length() < templateOrIndex.length();
    }

    public static boolean isDangling(String indexName) {
        return indexName.startsWith(".") && !indexName.startsWith(PARTITIONED_TABLE_PART) && !BlobIndex.isBlobIndex(indexName);
    }

    private static void assertPartitionPrefix(String prefix) {
        if (!PARTITIONED_KEY_WORD.equals(prefix)) {
            throw new IllegalArgumentException("Invalid partition prefix: " + prefix);
        }
    }

    private static void assertEmpty(String prefix) {
        if (!"".equals(prefix)) {
            throw new IllegalArgumentException("Invalid index name: " + prefix);
        }
    }
}

