/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GeoReference
extends Reference {
    private static final String DEFAULT_TREE = "geohash";
    private final String geoTree;
    @Nullable
    private final String precision;
    @Nullable
    private final Integer treeLevels;
    @Nullable
    private final Double distanceErrorPct;

    public GeoReference(Integer position, ReferenceIdent ident, @Nullable String tree, @Nullable String precision, @Nullable Integer treeLevels, @Nullable Double distanceErrorPct) {
        super(ident, RowGranularity.DOC, DataTypes.GEO_SHAPE, position, null);
        this.geoTree = Objects.requireNonNullElse(tree, DEFAULT_TREE);
        this.precision = precision;
        this.treeLevels = treeLevels;
        this.distanceErrorPct = distanceErrorPct;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.GEO_REFERENCE;
    }

    public String geoTree() {
        return this.geoTree;
    }

    @Nullable
    public String precision() {
        return this.precision;
    }

    @Nullable
    public Integer treeLevels() {
        return this.treeLevels;
    }

    @Nullable
    public Double distanceErrorPct() {
        return this.distanceErrorPct;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoReference that = (GeoReference)o;
        return Objects.equals(this.geoTree, that.geoTree) && Objects.equals(this.precision, that.precision) && Objects.equals(this.treeLevels, that.treeLevels) && Objects.equals(this.distanceErrorPct, that.distanceErrorPct);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.geoTree, this.precision, this.treeLevels, this.distanceErrorPct);
    }

    public GeoReference(StreamInput in) throws IOException {
        super(in);
        this.geoTree = in.readString();
        this.precision = in.readOptionalString();
        this.treeLevels = in.readBoolean() ? null : Integer.valueOf(in.readVInt());
        this.distanceErrorPct = in.readBoolean() ? null : Double.valueOf(in.readDouble());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.geoTree);
        out.writeOptionalString(this.precision);
        out.writeBoolean(this.treeLevels == null);
        if (this.treeLevels != null) {
            out.writeVInt(this.treeLevels);
        }
        out.writeBoolean(this.distanceErrorPct == null);
        if (this.distanceErrorPct != null) {
            out.writeDouble(this.distanceErrorPct);
        }
    }
}

