/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GeneratedReference
extends Reference {
    private final String formattedGeneratedExpression;
    private Symbol generatedExpression;
    private List<Reference> referencedReferences;

    public GeneratedReference(StreamInput in) throws IOException {
        super(in);
        this.formattedGeneratedExpression = in.readString();
        this.generatedExpression = Symbols.fromStream(in);
        int size = in.readVInt();
        this.referencedReferences = new ArrayList<Reference>(size);
        for (int i = 0; i < size; ++i) {
            this.referencedReferences.add((Reference)Reference.fromStream(in));
        }
    }

    public GeneratedReference(Integer position, ReferenceIdent ident, RowGranularity granularity, DataType type, ColumnPolicy columnPolicy, Reference.IndexType indexType, String formattedGeneratedExpression, boolean nullable) {
        super(ident, granularity, type, columnPolicy, indexType, nullable, position, null);
        this.formattedGeneratedExpression = formattedGeneratedExpression;
    }

    public GeneratedReference(Integer position, ReferenceIdent ident, RowGranularity granularity, DataType type, String formattedGeneratedExpression) {
        super(ident, granularity, type, position, null);
        this.formattedGeneratedExpression = formattedGeneratedExpression;
    }

    public String formattedGeneratedExpression() {
        return this.formattedGeneratedExpression;
    }

    public void generatedExpression(Symbol generatedExpression) {
        this.generatedExpression = generatedExpression;
    }

    public Symbol generatedExpression() {
        assert (this.generatedExpression != null) : "Generated expression symbol must not be NULL, initialize first";
        return this.generatedExpression;
    }

    public void referencedReferences(List<Reference> references) {
        this.referencedReferences = references;
    }

    public List<Reference> referencedReferences() {
        return this.referencedReferences;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.GENERATED_REFERENCE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeneratedReference that = (GeneratedReference)o;
        return Objects.equals(this.formattedGeneratedExpression, that.formattedGeneratedExpression) && Objects.equals(this.generatedExpression, that.generatedExpression) && Objects.equals(this.referencedReferences, that.referencedReferences);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.formattedGeneratedExpression, this.generatedExpression, this.referencedReferences);
    }

    @Override
    public String toString(Style style) {
        return this.column().quotedOutputName() + " AS " + this.formattedGeneratedExpression;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.formattedGeneratedExpression);
        Symbols.toStream(this.generatedExpression, out);
        out.writeVInt(this.referencedReferences.size());
        for (Reference reference : this.referencedReferences) {
            Reference.toStream(reference, out);
        }
    }
}

