/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.FunctionType;
import io.crate.metadata.SearchPath;
import io.crate.metadata.functions.BoundVariables;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.SignatureBinder;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;

public class Functions {
    private static final Logger LOGGER = Loggers.getLogger(Functions.class, new String[0]);
    private final Map<FunctionName, List<FunctionProvider>> udfFunctionImplementations = new ConcurrentHashMap<FunctionName, List<FunctionProvider>>();
    private final Map<FunctionName, List<FunctionProvider>> functionImplementations;

    public Functions copyOf() {
        Functions functions = new Functions(Map.copyOf(this.functionImplementations));
        functions.udfFunctionImplementations.putAll(this.udfFunctionImplementations);
        return functions;
    }

    @Inject
    public Functions(Map<FunctionName, List<FunctionProvider>> functionImplementationsBySignature) {
        this.functionImplementations = functionImplementationsBySignature;
    }

    public Map<FunctionName, List<FunctionProvider>> functionResolvers() {
        return this.functionImplementations;
    }

    public Map<FunctionName, List<FunctionProvider>> udfFunctionResolvers() {
        return this.udfFunctionImplementations;
    }

    public void registerUdfFunctionImplementationsForSchema(String schema, Map<FunctionName, List<FunctionProvider>> functions) {
        this.udfFunctionImplementations.entrySet().removeIf(function -> schema.equals(((FunctionName)function.getKey()).schema()) && functions.get(function.getKey()) == null);
        this.udfFunctionImplementations.putAll(functions);
    }

    public void deregisterUdfResolversForSchema(String schema) {
        this.udfFunctionImplementations.keySet().removeIf(function -> schema.equals(function.schema()));
    }

    @Nullable
    private static Signature findSignatureByOid(Map<FunctionName, List<FunctionProvider>> functions, int oid) {
        for (Map.Entry<FunctionName, List<FunctionProvider>> func : functions.entrySet()) {
            for (FunctionProvider sig : func.getValue()) {
                if (!Objects.equals(oid, OidHash.functionOid(sig.getSignature()))) continue;
                return sig.getSignature();
            }
        }
        return null;
    }

    @Nullable
    public Signature findFunctionSignatureByOid(int oid) {
        Signature sig = Functions.findSignatureByOid(this.udfFunctionImplementations, oid);
        return sig != null ? sig : Functions.findSignatureByOid(this.functionImplementations, oid);
    }

    public FunctionImplementation get(@Nullable String suppliedSchema, String functionName, List<Symbol> arguments, SearchPath searchPath) {
        return this.get(suppliedSchema, functionName, Symbols.typeView(arguments), arguments, searchPath);
    }

    private FunctionImplementation get(@Nullable String suppliedSchema, String functionName, List<DataType<?>> argumentTypes, List<Symbol> arguments, SearchPath searchPath) {
        FunctionName fqnName = new FunctionName(suppliedSchema, functionName);
        FunctionImplementation func = Functions.resolveFunctionBySignature(fqnName, argumentTypes, arguments, searchPath, this.functionImplementations);
        if (func == null) {
            func = Functions.resolveFunctionBySignature(fqnName, argumentTypes, arguments, searchPath, this.udfFunctionImplementations);
        }
        if (func == null) {
            Functions.raiseUnknownFunction(suppliedSchema, functionName, arguments, List.of());
        }
        return func;
    }

    @Nullable
    private FunctionImplementation get(Signature signature, List<DataType<?>> actualArgumentTypes, DataType<?> actualReturnType, Map<FunctionName, List<FunctionProvider>> candidatesByName) {
        List<FunctionProvider> candidates = candidatesByName.get(signature.getName());
        if (candidates == null) {
            return null;
        }
        for (FunctionProvider candidate : candidates) {
            if (!candidate.getSignature().equals(signature)) continue;
            Signature boundSignature = Signature.builder(signature).argumentTypes(Lists2.map(actualArgumentTypes, DataType::getTypeSignature)).returnType(actualReturnType.getTypeSignature()).build();
            return candidate.getFactory().apply(signature, boundSignature);
        }
        return null;
    }

    @Nullable
    private static FunctionImplementation resolveFunctionBySignature(FunctionName name, List<DataType<?>> argumentTypes, List<Symbol> arguments, SearchPath searchPath, Map<FunctionName, List<FunctionProvider>> candidatesByName) {
        List<FunctionProvider> candidates = candidatesByName.get(name);
        if (candidates == null && name.schema() == null) {
            String pathSchema;
            FunctionName searchPathFunctionName;
            Iterator<String> iterator = searchPath.iterator();
            while (iterator.hasNext() && (candidates = candidatesByName.get(searchPathFunctionName = new FunctionName(pathSchema = iterator.next(), name.name()))) == null) {
            }
        }
        if (candidates != null) {
            assert (candidates.stream().allMatch(f -> f.getSignature().getBindingInfo() != null)) : "Resolving/Matching of signatures can only be done with non-null signature's binding info";
            List<FunctionProvider> exactCandidates = candidates.stream().filter(function -> function.getSignature().getBindingInfo().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
            FunctionImplementation match = Functions.matchFunctionCandidates(exactCandidates, argumentTypes, SignatureBinder.CoercionType.NONE);
            if (match != null) {
                return match;
            }
            List<FunctionProvider> genericCandidates = candidates.stream().filter(function -> !function.getSignature().getBindingInfo().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
            match = Functions.matchFunctionCandidates(genericCandidates, argumentTypes, SignatureBinder.CoercionType.NONE);
            if (match != null) {
                return match;
            }
            List<FunctionProvider> candidatesAllowingCoercion = candidates.stream().filter(function -> function.getSignature().getBindingInfo().isCoercionAllowed()).collect(Collectors.toList());
            match = Functions.matchFunctionCandidates(candidatesAllowingCoercion, argumentTypes, SignatureBinder.CoercionType.PRECEDENCE_ONLY);
            if (match != null) {
                return match;
            }
            match = Functions.matchFunctionCandidates(candidatesAllowingCoercion, argumentTypes, SignatureBinder.CoercionType.FULL);
            if (match == null) {
                Functions.raiseUnknownFunction(name.schema(), name.name(), arguments, candidates);
            }
            return match;
        }
        return null;
    }

    @Nullable
    private static FunctionImplementation matchFunctionCandidates(List<FunctionProvider> candidates, List<DataType<?>> arguments, SignatureBinder.CoercionType coercionType) {
        List<ApplicableFunction> applicableFunctions = new ArrayList<ApplicableFunction>();
        for (FunctionProvider candidate : candidates) {
            Signature boundSignature = new SignatureBinder(candidate.getSignature(), coercionType).bind(Lists2.map(arguments, DataType::getTypeSignature));
            if (boundSignature == null) continue;
            applicableFunctions.add(new ApplicableFunction(candidate.getSignature(), boundSignature, candidate.getFactory()));
        }
        if (coercionType != SignatureBinder.CoercionType.NONE) {
            applicableFunctions = Functions.selectMostSpecificFunctions(applicableFunctions, arguments);
            if (LOGGER.isDebugEnabled() && applicableFunctions.isEmpty()) {
                LOGGER.debug("At least single function must be left after selecting most specific one");
            }
        }
        if (applicableFunctions.size() == 1) {
            return Lists2.getOnlyElement(applicableFunctions).get();
        }
        if (applicableFunctions.size() > 1 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multiple candidates match! " + applicableFunctions);
        }
        return null;
    }

    public FunctionImplementation getQualified(Function function, SearchPath searchPath) {
        Signature signature = function.signature();
        if (signature != null) {
            return this.getQualified(signature, Symbols.typeView(function.arguments()), function.valueType());
        }
        return this.get(function.info().ident().fqnName().schema(), function.info().ident().fqnName().name(), function.info().ident().argumentTypes(), function.arguments(), searchPath);
    }

    public FunctionImplementation getQualified(Aggregation function, SearchPath searchPath) {
        Signature signature = function.signature();
        if (signature != null) {
            return this.getQualified(signature, Symbols.typeView(function.inputs()), function.boundSignatureReturnType());
        }
        return this.get(function.functionIdent().fqnName().schema(), function.functionIdent().fqnName().name(), function.functionIdent().argumentTypes(), function.inputs(), searchPath);
    }

    public FunctionImplementation getQualified(Signature signature, List<DataType<?>> actualArgumentTypes, DataType<?> actualReturnType) throws UnsupportedOperationException {
        FunctionImplementation impl = this.get(signature, actualArgumentTypes, actualReturnType, this.functionImplementations);
        if (impl == null) {
            impl = this.get(signature, actualArgumentTypes, actualReturnType, this.udfFunctionImplementations);
        }
        return impl;
    }

    @VisibleForTesting
    static void raiseUnknownFunction(@Nullable String suppliedSchema, String name, List<Symbol> arguments, List<FunctionProvider> candidates) {
        List<DataType<?>> argumentTypes = Symbols.typeView(arguments);
        Function function = new Function(Signature.builder().name(new FunctionName(suppliedSchema, name)).argumentTypes(Lists2.map(argumentTypes, DataType::getTypeSignature)).returnType(DataTypes.UNDEFINED.getTypeSignature()).kind(FunctionType.SCALAR).build(), arguments, DataTypes.UNDEFINED);
        String message = "Unknown function: " + function.toString(Style.QUALIFIED);
        if (!candidates.isEmpty()) {
            message = !arguments.isEmpty() ? message + ", no overload found for matching argument types: (" + Lists2.joinOn(", ", argumentTypes, DataType::toString) + ")." : message + ".";
            message = message + " Possible candidates: " + Lists2.joinOn(", ", candidates, c -> c.getSignature().getName().displayName() + "(" + Lists2.joinOn(", ", c.getSignature().getArgumentTypes(), TypeSignature::toString) + "):" + c.getSignature().getReturnType().toString());
        }
        throw new UnsupportedOperationException(message);
    }

    private static List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<DataType<?>> arguments) {
        if (applicableFunctions.isEmpty()) {
            return applicableFunctions;
        }
        List<TypeSignature> argumentTypeSignatures = Lists2.map(arguments, DataType::getTypeSignature);
        List<ApplicableFunction> mostSpecificFunctions = Functions.selectMostSpecificFunctions(applicableFunctions, (ApplicableFunction l, ApplicableFunction r) -> Functions.hasMoreExactTypeMatches(l, r, argumentTypeSignatures));
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        if ((mostSpecificFunctions = Functions.selectMostSpecificFunctions(mostSpecificFunctions, Functions::isMoreSpecificThan)).size() <= 1) {
            return mostSpecificFunctions;
        }
        if (Functions.returnTypeIsTheSame(mostSpecificFunctions) || arguments.stream().allMatch(s -> s.id() == DataTypes.UNDEFINED.id())) {
            ApplicableFunction selectedFunction = (ApplicableFunction)mostSpecificFunctions.stream().sorted(Comparator.comparing(Objects::toString)).iterator().next();
            return List.of(selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private static List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates, BiFunction<ApplicableFunction, ApplicableFunction, Boolean> isMoreSpecific) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (isMoreSpecific.apply(current, representative).booleanValue()) {
                    representatives.clear();
                    representatives.add(current);
                    found = true;
                    break;
                }
                if (!isMoreSpecific.apply(representative, current).booleanValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        int rightArgsCount;
        List<TypeSignature> resolvedTypes = left.getBoundSignature().getArgumentTypes();
        BoundVariables boundVariables = SignatureBinder.withPrecedenceOnly(right.getDeclaredSignature()).bindVariables(resolvedTypes);
        if (boundVariables == null) {
            return false;
        }
        int leftArgsCount = left.getDeclaredSignature().getArgumentTypes().size();
        return leftArgsCount >= (rightArgsCount = right.getDeclaredSignature().getArgumentTypes().size());
    }

    private static boolean hasMoreExactTypeMatches(ApplicableFunction left, ApplicableFunction right, List<TypeSignature> actualArgumentTypes) {
        int rightExactMatches;
        int leftExactMatches = Functions.numberOfExactTypeMatches(actualArgumentTypes, left.getDeclaredSignature().getArgumentTypes());
        return leftExactMatches > (rightExactMatches = Functions.numberOfExactTypeMatches(actualArgumentTypes, right.getDeclaredSignature().getArgumentTypes()));
    }

    private static boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> function.getBoundSignature().getReturnType().createType()).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private static int numberOfExactTypeMatches(List<TypeSignature> actualArgumentTypes, List<TypeSignature> declaredArgumentTypes) {
        int cnt = 0;
        for (int i = 0; i < actualArgumentTypes.size(); ++i) {
            if (declaredArgumentTypes.size() <= i || !actualArgumentTypes.get(i).equals(declaredArgumentTypes.get(i))) continue;
            ++cnt;
        }
        return cnt;
    }

    private static class ApplicableFunction
    implements Supplier<FunctionImplementation> {
        private final Signature declaredSignature;
        private final Signature boundSignature;
        private final BiFunction<Signature, Signature, FunctionImplementation> factory;

        public ApplicableFunction(Signature declaredSignature, Signature boundSignature, BiFunction<Signature, Signature, FunctionImplementation> factory) {
            this.declaredSignature = declaredSignature;
            this.boundSignature = boundSignature;
            this.factory = factory;
        }

        public Signature getDeclaredSignature() {
            return this.declaredSignature;
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        @Override
        public FunctionImplementation get() {
            return this.factory.apply(this.declaredSignature, this.boundSignature);
        }

        public String toString() {
            return "ApplicableFunction{declaredSignature=" + this.declaredSignature + ", boundSignature=" + this.boundSignature + "}";
        }
    }
}

