/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class FunctionName
implements Writeable {
    @Nullable
    private final String schema;
    private final String name;

    public FunctionName(@Nullable String schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public FunctionName(String name) {
        this(null, name);
    }

    public FunctionName(StreamInput in) throws IOException {
        this.schema = in.readOptionalString();
        this.name = in.readString();
    }

    @Nullable
    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.schema);
        out.writeString(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionName that = (FunctionName)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.name);
    }

    public String toString() {
        return "FunctionName{schema='" + this.schema + "', name='" + this.name + "'}";
    }

    public String displayName() {
        if (this.schema == null) {
            return this.name;
        }
        return this.schema + "." + this.name;
    }
}

