/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.common.collections.EnumSets;
import io.crate.metadata.FunctionIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class FunctionInfo
implements Writeable {
    private final FunctionIdent ident;
    private final DataType<?> returnType;
    private final FunctionType type;
    private final Set<Scalar.Feature> features;

    public static FunctionInfo of(Signature signature) {
        return new FunctionInfo(new FunctionIdent(signature.getName(), signature.getArgumentDataTypes()), signature.getReturnType().createType(), signature.getKind(), signature.getFeatures());
    }

    public static FunctionInfo of(Signature signature, List<DataType<?>> argumentTypes, DataType<?> returnType) {
        return new FunctionInfo(new FunctionIdent(signature.getName(), argumentTypes), returnType, signature.getKind(), signature.getFeatures());
    }

    public FunctionInfo(FunctionIdent ident, DataType<?> returnType, FunctionType type, Set<Scalar.Feature> features) {
        assert (features.size() < 32) : "features size must not exceed 32";
        this.ident = ident;
        this.returnType = returnType;
        this.type = type;
        this.features = features;
    }

    public FunctionIdent ident() {
        return this.ident;
    }

    public FunctionType type() {
        return this.type;
    }

    public DataType<?> returnType() {
        return this.returnType;
    }

    public Set<Scalar.Feature> features() {
        return this.features;
    }

    public boolean hasFeature(Scalar.Feature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean isDeterministic() {
        return this.hasFeature(Scalar.Feature.DETERMINISTIC);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionInfo info = (FunctionInfo)o;
        return Objects.equals(this.ident, info.ident) && Objects.equals(this.returnType, info.returnType) && this.type == info.type && Objects.equals(this.features, info.features);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ident, this.returnType, this.type, this.features});
    }

    public String toString() {
        return "FunctionInfo{type=" + this.type + ", ident=" + this.ident + ", returnType=" + this.returnType + ", features=" + this.features + "}";
    }

    public FunctionInfo(StreamInput in) throws IOException {
        this.ident = new FunctionIdent(in);
        this.returnType = DataTypes.fromStream(in);
        this.type = FunctionType.values()[in.readVInt()];
        int enumElements = in.readVInt();
        this.features = Collections.unmodifiableSet(EnumSets.unpackFromInt(enumElements, Scalar.Feature.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.ident.writeTo(out);
        DataTypes.toStream(this.returnType, out);
        out.writeVInt(this.type.ordinal());
        out.writeVInt(EnumSets.packToInt(this.features));
    }
}

