/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.FunctionName;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class FunctionIdent
implements Writeable {
    private final FunctionName fqnName;
    private final List<DataType<?>> argumentTypes;

    public FunctionIdent(FunctionName functionName, List<DataType<?>> argumentTypes) {
        this.fqnName = functionName;
        this.argumentTypes = argumentTypes;
    }

    public List<DataType<?>> argumentTypes() {
        return this.argumentTypes;
    }

    public String name() {
        return this.fqnName.name();
    }

    public FunctionName fqnName() {
        return this.fqnName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionIdent o = (FunctionIdent)obj;
        return Objects.equals(this.fqnName, o.fqnName) && Objects.equals(this.argumentTypes, o.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.fqnName, this.argumentTypes);
    }

    public String toString() {
        return "FunctionIdent{" + this.fqnName.toString() + ", argumentTypes=" + this.argumentTypes + "}";
    }

    public FunctionIdent(StreamInput in) throws IOException {
        this.fqnName = new FunctionName(in);
        int numTypes = in.readVInt();
        this.argumentTypes = new ArrayList(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            this.argumentTypes.add(DataTypes.fromStream(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.fqnName.writeTo(out);
        out.writeVInt(this.argumentTypes.size());
        for (DataType<?> argumentType : this.argumentTypes) {
            DataTypes.toStream(argumentType, out);
        }
    }
}

