/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import java.util.function.Predicate;

public final class DocReferences {
    private DocReferences() {
    }

    public static Symbol inverseSourceLookup(Symbol symbol) {
        return RefReplacer.replaceRefs(symbol, DocReferences::docRefToRegularRef);
    }

    public static Symbol toSourceLookup(Symbol tree) {
        return RefReplacer.replaceRefs(tree, DocReferences::toSourceLookup);
    }

    public static Symbol toSourceLookup(Symbol tree, Predicate<Reference> condition) {
        return RefReplacer.replaceRefs(tree, r -> DocReferences.toSourceLookup(r, condition));
    }

    public static Reference toSourceLookup(Reference reference) {
        return DocReferences.toSourceLookup(reference, (Reference r) -> true);
    }

    private static Reference toSourceLookup(Reference reference, Predicate<Reference> condition) {
        ReferenceIdent ident = reference.ident();
        if (ident.columnIdent().isSystemColumn()) {
            return reference;
        }
        if (reference.granularity() == RowGranularity.DOC && Schemas.isDefaultOrCustomSchema(ident.tableIdent().schema()) && condition.test(reference)) {
            return reference.getRelocated(new ReferenceIdent(ident.tableIdent(), ident.columnIdent().prepend("_doc")));
        }
        return reference;
    }

    public static Reference docRefToRegularRef(Reference ref) {
        ColumnIdent column = ref.column();
        if (!column.isTopLevel() && column.name().equals("_doc")) {
            return ref.getRelocated(new ReferenceIdent(ref.ident().tableIdent(), column.shiftRight()));
        }
        return ref;
    }
}

