/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

@Singleton
public class DefaultTemplateService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(DefaultTemplateService.class);
    public static final String TEMPLATE_NAME = "crate_defaults";
    private static final String DEFAULT_MAPPING_SOURCE = DefaultTemplateService.createDefaultMappingSource();
    private final ClusterService clusterService;

    @Inject
    public DefaultTemplateService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.clusterService.removeListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.createIfNotExists(event.state());
    }

    void createIfNotExists(ClusterState state) {
        DiscoveryNodes nodes = state.nodes();
        if (!Objects.equals(nodes.getMasterNodeId(), nodes.getLocalNodeId())) {
            return;
        }
        if (!state.getMetadata().getTemplates().containsKey(TEMPLATE_NAME)) {
            this.createDefaultTemplate();
        }
    }

    private void createDefaultTemplate() {
        this.clusterService.submitStateUpdateTask("ensure-default-template", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return DefaultTemplateService.addDefaultTemplate(currentState);
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOGGER.error("Error during ensure-default-template source={}", (Object)e, (Object)source);
            }
        });
    }

    @VisibleForTesting
    static ClusterState addDefaultTemplate(ClusterState currentState) throws IOException {
        Metadata currentMetadata = currentState.getMetadata();
        ImmutableOpenMap<String, IndexTemplateMetadata> currentTemplates = currentMetadata.getTemplates();
        ImmutableOpenMap<String, IndexTemplateMetadata> newTemplates = DefaultTemplateService.createCopyWithDefaultTemplateAdded(currentTemplates);
        Metadata.Builder mdBuilder = Metadata.builder(currentMetadata).templates(newTemplates);
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    private static ImmutableOpenMap<String, IndexTemplateMetadata> createCopyWithDefaultTemplateAdded(ImmutableOpenMap<String, IndexTemplateMetadata> currentTemplates) throws IOException {
        ImmutableOpenMap.Builder<String, IndexTemplateMetadata> builder = ImmutableOpenMap.builder(currentTemplates);
        builder.put(TEMPLATE_NAME, DefaultTemplateService.createDefaultIndexTemplateMetadata());
        return builder.build();
    }

    public static IndexTemplateMetadata createDefaultIndexTemplateMetadata() throws IOException {
        return IndexTemplateMetadata.builder(TEMPLATE_NAME).order(0).putMapping("default", DEFAULT_MAPPING_SOURCE).patterns(Collections.singletonList("*")).build();
    }

    private static String createDefaultMappingSource() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("default").startArray("dynamic_templates").startObject().startObject("strings").field("match_mapping_type", "string").startObject("mapping").field("type", "keyword").field("doc_values", true).field("store", false).endObject().endObject().endObject().endArray().endObject().endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

