/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.metadata.IndexParts;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class DanglingArtifactsService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(DanglingArtifactsService.class);
    private final ClusterService clusterService;
    private final List<Pattern> danglingPatterns;

    @Inject
    public DanglingArtifactsService(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.danglingPatterns = IndexParts.DANGLING_INDICES_PREFIX_PATTERNS.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (LOGGER.isInfoEnabled() && event.isNewCluster()) {
            for (ObjectCursor key : event.state().metadata().indices().keys()) {
                for (Pattern pattern : this.danglingPatterns) {
                    if (!pattern.matcher((CharSequence)key.value).matches()) continue;
                    LOGGER.info("Dangling artifacts exist in the cluster. Use 'alter cluster gc dangling artifacts;' to remove them");
                    this.doStop();
                    return;
                }
            }
        }
    }
}

