/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.action.sql.SessionContext;
import io.crate.metadata.SystemClock;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.settings.SessionSettings;
import java.time.Instant;
import java.util.Objects;

public final class CoordinatorTxnCtx
implements TransactionContext {
    private final SessionContext sessionContext;
    private Instant currentInstant;

    public static CoordinatorTxnCtx systemTransactionContext() {
        return new CoordinatorTxnCtx(SessionContext.systemSessionContext());
    }

    public CoordinatorTxnCtx(SessionContext sessionContext) {
        this.sessionContext = Objects.requireNonNull(sessionContext);
    }

    @Override
    public Instant currentInstant() {
        if (this.currentInstant == null) {
            this.currentInstant = SystemClock.currentInstant();
        }
        return this.currentInstant;
    }

    @Override
    public SessionSettings sessionSettings() {
        return new SessionSettings(this.sessionContext.sessionUser().name(), this.sessionContext.searchPath(), this.sessionContext.isHashJoinEnabled(), this.sessionContext.excludedOptimizerRules());
    }

    public SessionContext sessionContext() {
        return this.sessionContext;
    }
}

