/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import io.crate.common.StringUtils;
import io.crate.common.collections.Lists2;
import io.crate.exceptions.InvalidColumnNameException;
import io.crate.sql.Identifiers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ColumnIdent
implements Comparable<ColumnIdent> {
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("^_([a-z][_a-z]*)*[a-z]$");
    private static final Pattern SUBSCRIPT_PATTERN = Pattern.compile("^\\w+(\\[[^\\]]+\\])+");
    private static final Ordering<Iterable<String>> ORDERING = Ordering.natural().lexicographical();
    private final String name;
    private final List<String> path;

    public ColumnIdent(StreamInput in) throws IOException {
        this.name = in.readString();
        int numParts = in.readVInt();
        if (numParts > 0) {
            this.path = new ArrayList<String>(numParts);
            for (int i = 0; i < numParts; ++i) {
                this.path.add(in.readString());
            }
        } else {
            this.path = List.of();
        }
    }

    public ColumnIdent(String name) {
        this.name = name;
        this.path = List.of();
    }

    public ColumnIdent(String name, String childName) {
        this(name, List.of(childName));
    }

    public ColumnIdent(String name, @Nullable List<String> path) {
        this.name = name;
        this.path = Objects.requireNonNullElse(path, List.of());
    }

    public static ColumnIdent fromNameSafe(String name) {
        ColumnIdent.validateColumnName(name);
        return new ColumnIdent(name);
    }

    public static ColumnIdent fromNameAndPathSafe(String name, List<String> path) {
        ColumnIdent.validateColumnName(name);
        for (String part : path) {
            ColumnIdent.validateObjectKey(part);
        }
        return new ColumnIdent(name, path);
    }

    public static ColumnIdent getChildSafe(ColumnIdent parent, String name) {
        ColumnIdent.validateObjectKey(name);
        return ColumnIdent.getChild(parent, name);
    }

    public static ColumnIdent fromPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        List<String> parts = StringUtils.splitToList('.', path);
        if (parts.size() > 1) {
            return new ColumnIdent(parts.get(0), parts.subList(1, parts.size()));
        }
        return new ColumnIdent(parts.get(0));
    }

    public static ColumnIdent getChild(ColumnIdent parent, String name) {
        if (parent.isTopLevel()) {
            return new ColumnIdent(parent.name, name);
        }
        ArrayList<String> childPath = new ArrayList<String>();
        childPath.addAll(parent.path);
        childPath.add(name);
        return new ColumnIdent(parent.name, childPath);
    }

    public static Object get(Map map, ColumnIdent column) {
        Object obj = map.get(column.name);
        if (obj instanceof Map) {
            Map m = (Map)obj;
            Object element = null;
            for (int i = 0; i < column.path.size(); ++i) {
                element = m.get(column.path.get(i));
                if (!(element instanceof Map)) {
                    return element;
                }
                m = element;
            }
            return element;
        }
        return obj;
    }

    public boolean isChildOf(ColumnIdent parent) {
        if (!this.name.equals(parent.name)) {
            return false;
        }
        if (this.path.size() > parent.path.size()) {
            Iterator<String> parentIt = parent.path.iterator();
            Iterator<String> it = this.path.iterator();
            while (parentIt.hasNext()) {
                if (parentIt.next().equals(it.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void validateColumnName(String columnName) {
        ColumnIdent.validateDotInColumnName(columnName);
        ColumnIdent.validateSubscriptPatternInColumnName(columnName);
        ColumnIdent.validateUnderscorePatternInColumnName(columnName);
    }

    public static void validateObjectKey(String columnName) {
        ColumnIdent.validateDotInColumnName(columnName);
        ColumnIdent.validateSubscriptPatternInColumnName(columnName);
    }

    private static void validateDotInColumnName(String columnName) {
        if (columnName.indexOf(46) != -1) {
            throw new InvalidColumnNameException(columnName, "contains a dot");
        }
    }

    private static void validateSubscriptPatternInColumnName(String columnName) {
        if (SUBSCRIPT_PATTERN.matcher(columnName).matches()) {
            throw new InvalidColumnNameException(columnName, "conflicts with subscript pattern");
        }
    }

    private static void validateUnderscorePatternInColumnName(String columnName) {
        if (UNDERSCORE_PATTERN.matcher(columnName).matches()) {
            throw new InvalidColumnNameException(columnName, "conflicts with system column pattern");
        }
    }

    @Nullable
    public ColumnIdent getParent() {
        switch (this.path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new ColumnIdent(this.name);
            }
        }
        return new ColumnIdent(this.name, this.path.subList(0, this.path.size() - 1));
    }

    @Nullable
    public ColumnIdent shiftRight() {
        switch (this.path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new ColumnIdent(this.path.get(0));
            }
        }
        return new ColumnIdent(this.path.get(0), this.path.subList(1, this.path.size()));
    }

    public boolean isSystemColumn() {
        return UNDERSCORE_PATTERN.matcher(this.name).matches();
    }

    public ColumnIdent getRoot() {
        if (this.isTopLevel()) {
            return this;
        }
        return new ColumnIdent(this.name());
    }

    public String name() {
        return this.name;
    }

    public String fqn() {
        if (this.isTopLevel()) {
            return this.name;
        }
        StringJoiner stringJoiner = new StringJoiner(".");
        stringJoiner.add(this.name);
        for (String p : this.path) {
            stringJoiner.add(p);
        }
        return stringJoiner.toString();
    }

    public String quotedOutputName() {
        return this.sqlFqn(Identifiers.quoteIfNeeded(this.name));
    }

    public String sqlFqn() {
        return this.sqlFqn(this.name);
    }

    private String sqlFqn(String name) {
        StringBuilder sb = new StringBuilder(name);
        for (String s : this.path) {
            sb.append("['");
            sb.append(s);
            sb.append("']");
        }
        return sb.toString();
    }

    public List<String> path() {
        return this.path;
    }

    public boolean isTopLevel() {
        return this.path.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnIdent that = (ColumnIdent)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public String toString() {
        return this.sqlFqn();
    }

    @Override
    public int compareTo(ColumnIdent o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)o.name)).compare(this.path, o.path, ORDERING).result();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.path.size());
        for (String s : this.path) {
            out.writeString(s);
        }
    }

    public ColumnIdent prepend(String name) {
        if (this.path.isEmpty()) {
            return new ColumnIdent(name, this.name);
        }
        ArrayList<String> newPath = new ArrayList<String>(this.path);
        newPath.add(0, this.name);
        return new ColumnIdent(name, newPath);
    }

    public String leafName() {
        if (this.path.isEmpty()) {
            return this.name;
        }
        return this.path.get(this.path.size() - 1);
    }

    public ColumnIdent append(String childName) {
        if (this.path.isEmpty()) {
            return new ColumnIdent(this.name, childName);
        }
        return new ColumnIdent(this.name, Lists2.concat(this.path, childName));
    }
}

