/*
 * Decompiled with CFR 0.152.
 */
package io.crate.memory;

import io.crate.breaker.RamAccounting;
import io.crate.memory.MemoryManager;
import io.crate.memory.OffHeapMemoryManager;
import io.crate.memory.OnHeapMemoryManager;
import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

@Singleton
public final class MemoryManagerFactory
implements Function<RamAccounting, MemoryManager> {
    private static final Set<String> TYPES = Set.of(MemoryType.OFF_HEAP.value(), MemoryType.ON_HEAP.value());
    public static final CrateSetting<String> MEMORY_ALLOCATION_TYPE = CrateSetting.of(new Setting<String>("memory.allocation.type", MemoryType.ON_HEAP.value(), input -> {
        if (TYPES.contains(input)) {
            return input;
        }
        throw new IllegalArgumentException("Invalid argument `" + input + "` for `memory.allocation.type`, valid values are: " + TYPES);
    }, Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING);
    private volatile MemoryType currentMemoryType = MemoryType.ON_HEAP;

    @Inject
    public MemoryManagerFactory(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(MEMORY_ALLOCATION_TYPE.setting(), newValue -> {
            this.currentMemoryType = MemoryType.of(newValue);
        });
    }

    public MemoryManager getMemoryManager(RamAccounting ramAccounting) {
        switch (this.currentMemoryType) {
            case ON_HEAP: {
                return new OnHeapMemoryManager(ramAccounting::addBytes);
            }
            case OFF_HEAP: {
                return new OffHeapMemoryManager();
            }
        }
        throw new AssertionError((Object)"MemoryType is supposed to have only 2 cases");
    }

    @Override
    public MemoryManager apply(RamAccounting ramAccounting) {
        return this.getMemoryManager(ramAccounting);
    }

    static enum MemoryType {
        ON_HEAP("on-heap"),
        OFF_HEAP("off-heap");

        private final String value;

        private MemoryType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static MemoryType of(String value) {
            if (value.equals(MemoryType.ON_HEAP.value)) {
                return ON_HEAP;
            }
            if (value.equals(MemoryType.OFF_HEAP.value)) {
                return OFF_HEAP;
            }
            throw new IllegalArgumentException("Invalid memory type `" + value + "`. Expected one of: " + TYPES);
        }
    }
}

