/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene.match;

import javax.annotation.Nullable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MultiTermQuery;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.search.MatchQuery;

public class ParsedOptions {
    private final Float boost;
    private final String analyzer;
    private final MatchQuery.ZeroTermsQuery zeroTermsQuery;
    private final int maxExpansions;
    private final Fuzziness fuzziness;
    private final int prefixLength;
    private final boolean transpositions;
    private Float commonTermsCutoff;
    private BooleanClause.Occur operator = BooleanClause.Occur.SHOULD;
    private String minimumShouldMatch;
    private int phraseSlop = 0;
    private Float tieBreaker;
    private MultiTermQuery.RewriteMethod rewrite;

    public ParsedOptions(Float boost, String analyzer, MatchQuery.ZeroTermsQuery zeroTermsQuery, int maxExpansions, Fuzziness fuzziness, int prefixLength, boolean transpositions) {
        this.boost = boost;
        this.analyzer = analyzer;
        this.zeroTermsQuery = zeroTermsQuery;
        this.maxExpansions = maxExpansions;
        this.fuzziness = fuzziness;
        this.prefixLength = prefixLength;
        this.transpositions = transpositions;
    }

    @Nullable
    public Float boost() {
        return this.boost;
    }

    public void commonTermsCutoff(Float cutoff) {
        this.commonTermsCutoff = cutoff;
    }

    @Nullable
    public Float commonTermsCutoff() {
        return this.commonTermsCutoff;
    }

    public void operator(BooleanClause.Occur operator) {
        this.operator = operator;
    }

    public BooleanClause.Occur operator() {
        return this.operator;
    }

    public void minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
    }

    public void phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void tieBreaker(Float tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    @Nullable
    public Float tieBreaker() {
        return this.tieBreaker;
    }

    public void rewrite(MultiTermQuery.RewriteMethod rewrite) {
        this.rewrite = rewrite;
    }

    public int phraseSlop() {
        return this.phraseSlop;
    }

    public int maxExpansions() {
        return this.maxExpansions;
    }

    @Nullable
    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public MatchQuery.ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public MultiTermQuery.RewriteMethod rewriteMethod() {
        return this.rewrite;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public boolean transpositions() {
        return this.transpositions;
    }
}

