/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene.match;

import com.google.common.base.Joiner;
import io.crate.lucene.match.ParsedOptions;
import io.crate.types.BooleanType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.query.MultiMatchQueryType;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.MatchQuery;

public class OptionParser {
    private static final Set<String> SUPPORTED_OPTIONS = Set.of("analyzer", "boost", "operator", "cutoff_frequency", "minimum_should_match", "fuzziness", "prefix_length", "max_expansions", "rewrite", "slop", "tie_breaker", "zero_terms_query", "fuzzy_rewrite", "fuzzy_transpositions");

    public static ParsedOptions parse(MultiMatchQueryType matchType, @Nullable Map options) throws IllegalArgumentException {
        options = options == null ? Collections.emptyMap() : new HashMap(options);
        ParsedOptions parsedOptions = new ParsedOptions(OptionParser.floatValue(options, "boost", null), OptionParser.analyzer(options.remove("analyzer")), OptionParser.zeroTermsQuery(options.remove("zero_terms_query")), OptionParser.intValue(options, "max_expansions", 50), OptionParser.fuzziness(options.remove("fuzziness")), OptionParser.intValue(options, "prefix_length", 0), OptionParser.transpositions(options.remove("fuzzy_transpositions")));
        switch (matchType.matchQueryType()) {
            case BOOLEAN: {
                parsedOptions.commonTermsCutoff(OptionParser.floatValue(options, "cutoff_frequency", null));
                parsedOptions.operator(OptionParser.operator(options.remove("operator")));
                parsedOptions.minimumShouldMatch(OptionParser.minimumShouldMatch(options.remove("minimum_should_match")));
                break;
            }
            case PHRASE: {
                parsedOptions.phraseSlop(OptionParser.intValue(options, "slop", 0));
                parsedOptions.tieBreaker(OptionParser.floatValue(options, "tie_breaker", null));
                break;
            }
            case PHRASE_PREFIX: {
                parsedOptions.phraseSlop(OptionParser.intValue(options, "slop", 0));
                parsedOptions.tieBreaker(OptionParser.floatValue(options, "tie_breaker", null));
                parsedOptions.rewrite(OptionParser.rewrite(options.remove("rewrite")));
                break;
            }
        }
        if (!options.isEmpty()) {
            OptionParser.raiseIllegalOptions(matchType, options);
        }
        return parsedOptions;
    }

    private static Boolean transpositions(@Nullable Object transpositions) {
        if (transpositions == null) {
            return false;
        }
        return BooleanType.INSTANCE.implicitCast(transpositions);
    }

    @Nullable
    private static String minimumShouldMatch(@Nullable Object minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            return null;
        }
        return minimumShouldMatch.toString();
    }

    private static BooleanClause.Occur operator(@Nullable Object operator) {
        if (operator == null) {
            return BooleanClause.Occur.SHOULD;
        }
        String op = BytesRefs.toString(operator);
        if ("or".equalsIgnoreCase(op)) {
            return BooleanClause.Occur.SHOULD;
        }
        if ("and".equalsIgnoreCase(op)) {
            return BooleanClause.Occur.MUST;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "value for operator must be either \"or\" or \"and\" not \"%s\"", op));
    }

    private static Float floatValue(Map options, String optionName, Float defaultValue) {
        Object o = options.remove(optionName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "value for %s must be a number", optionName));
    }

    private static Integer intValue(Map options, String optionName, Integer defaultValue) {
        Object o = options.remove(optionName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "value for %s must be a number", optionName));
    }

    @Nullable
    private static MultiTermQuery.RewriteMethod rewrite(@Nullable Object fuzzyRewrite) {
        if (fuzzyRewrite == null) {
            return null;
        }
        return QueryParsers.parseRewriteMethod(fuzzyRewrite.toString(), LoggingDeprecationHandler.INSTANCE);
    }

    @Nullable
    private static Fuzziness fuzziness(@Nullable Object fuzziness) {
        if (fuzziness == null) {
            return null;
        }
        return Fuzziness.build(BytesRefs.toString(fuzziness));
    }

    private static MatchQuery.ZeroTermsQuery zeroTermsQuery(@Nullable Object zeroTermsQuery) {
        String value = BytesRefs.toString(zeroTermsQuery);
        if (value == null || "none".equalsIgnoreCase(value)) {
            return MatchQuery.ZeroTermsQuery.NONE;
        }
        if ("all".equalsIgnoreCase(value)) {
            return MatchQuery.ZeroTermsQuery.ALL;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unsupported value for %s option. Valid are \"none\" and \"all\"", "zero_terms_query"));
    }

    @Nullable
    private static String analyzer(@Nullable Object analyzer) {
        if (analyzer == null) {
            return null;
        }
        if (analyzer instanceof String || analyzer instanceof BytesRef) {
            return BytesRefs.toString(analyzer);
        }
        throw new IllegalArgumentException("value for analyzer must be a string");
    }

    private static void raiseIllegalOptions(MultiMatchQueryType matchType, Map options) {
        ArrayList<String> unknownOptions = new ArrayList<String>();
        ArrayList<String> invalidOptions = new ArrayList<String>();
        for (Object o : options.keySet()) {
            assert (o instanceof String) : "option must be String";
            if (!SUPPORTED_OPTIONS.contains(o)) {
                unknownOptions.add((String)o);
                continue;
            }
            invalidOptions.add((String)o);
        }
        if (!unknownOptions.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "match predicate doesn't support any of the given options: %s", Joiner.on((String)", ").join(unknownOptions)));
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "match predicate option(s) \"%s\" cannot be used with matchType \"%s\"", Joiner.on((String)", ").join(invalidOptions), matchType.name().toLowerCase(Locale.ENGLISH)));
    }

    private static class OPTIONS {
        static final String ANALYZER = "analyzer";
        static final String BOOST = "boost";
        static final String OPERATOR = "operator";
        static final String CUTOFF_FREQUENCY = "cutoff_frequency";
        static final String MINIMUM_SHOULD_MATCH = "minimum_should_match";
        static final String FUZZINESS = "fuzziness";
        static final String PREFIX_LENGTH = "prefix_length";
        static final String MAX_EXPANSIONS = "max_expansions";
        static final String REWRITE = "rewrite";
        static final String SLOP = "slop";
        static final String TIE_BREAKER = "tie_breaker";
        static final String ZERO_TERMS_QUERY = "zero_terms_query";
        static final String FUZZY_REWRITE = "fuzzy_rewrite";
        static final String FUZZY_TRANSPOSITIONS = "fuzzy_transpositions";

        private OPTIONS() {
        }
    }
}

